/*
 * Decompiled with CFR 0.152.
 */
package dev.denismasterherobrine.afterdark.features;

import com.mojang.serialization.Codec;
import dev.denismasterherobrine.afterdark.features.configuration.DoubleBlockConfiguration;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class PondFeature
extends Feature<DoubleBlockConfiguration> {
    public PondFeature(Codec<DoubleBlockConfiguration> pContext) {
        super(pContext);
    }

    public boolean place(FeaturePlaceContext<DoubleBlockConfiguration> pContext) {
        WorldGenLevel worldgenlevel = pContext.level();
        BlockPos blockpos = pContext.origin();
        RandomSource random = pContext.random();
        BlockState material = ((DoubleBlockConfiguration)pContext.config()).toPlace().getState(random, blockpos);
        BlockState slab = ((DoubleBlockConfiguration)pContext.config()).slabToPlace().getState(random, blockpos);
        BlockState water = Blocks.WATER.defaultBlockState();
        BlockState mud = Blocks.MUD.defaultBlockState();
        if (!worldgenlevel.getBlockState(blockpos.offset(3, 0, 0)).canBeReplaced() && !worldgenlevel.getBlockState(blockpos.offset(0, 0, 3)).canBeReplaced() || !worldgenlevel.getBlockState(blockpos.offset(-3, 0, 0)).canBeReplaced() && !worldgenlevel.getBlockState(blockpos.offset(0, 0, -3)).canBeReplaced() || !worldgenlevel.getBlockState(blockpos.offset(2, -1, 2)).canBeReplaced() && !worldgenlevel.getBlockState(blockpos.offset(-2, -1, 2)).canBeReplaced() || !worldgenlevel.getBlockState(blockpos.offset(-2, -1, -2)).canBeReplaced() && !worldgenlevel.getBlockState(blockpos.offset(2, -1, -2)).canBeReplaced()) {
            return false;
        }
        worldgenlevel.setBlock(blockpos.offset(0, -1, 0), water, 2);
        worldgenlevel.setBlock(blockpos.offset(0, 0, 0), Blocks.LILY_PAD.defaultBlockState(), 2);
        worldgenlevel.setBlock(blockpos.offset(1, -1, 0), water, 2);
        worldgenlevel.setBlock(blockpos.offset(0, -1, 1), water, 2);
        worldgenlevel.setBlock(blockpos.offset(-1, -1, 0), water, 2);
        worldgenlevel.setBlock(blockpos.offset(0, -1, -1), water, 2);
        worldgenlevel.setBlock(blockpos.offset(1, -1, 1), water, 2);
        worldgenlevel.setBlock(blockpos.offset(-1, -1, -1), water, 2);
        worldgenlevel.setBlock(blockpos.offset(-1, -1, 1), water, 2);
        worldgenlevel.setBlock(blockpos.offset(-1, -1, 1), Blocks.SEAGRASS.defaultBlockState(), 2);
        worldgenlevel.setBlock(blockpos.offset(1, -1, -1), water, 2);
        worldgenlevel.setBlock(blockpos.offset(0, -2, 0), mud, 2);
        worldgenlevel.setBlock(blockpos.offset(1, -2, 0), mud, 2);
        worldgenlevel.setBlock(blockpos.offset(0, -2, 1), mud, 2);
        worldgenlevel.setBlock(blockpos.offset(-1, -2, 0), mud, 2);
        worldgenlevel.setBlock(blockpos.offset(0, -2, -1), mud, 2);
        worldgenlevel.setBlock(blockpos.offset(1, -2, 1), mud, 2);
        worldgenlevel.setBlock(blockpos.offset(-1, -2, -1), mud, 2);
        worldgenlevel.setBlock(blockpos.offset(-1, -2, 1), mud, 2);
        worldgenlevel.setBlock(blockpos.offset(1, -2, -1), mud, 2);
        this.replaceAir(worldgenlevel, blockpos.offset(-2, -1, -1), material);
        this.replaceAir(worldgenlevel, blockpos.offset(-2, -1, 0), material);
        this.replaceAir(worldgenlevel, blockpos.offset(-2, -1, 1), material);
        this.replaceAir(worldgenlevel, blockpos.offset(2, -1, -1), material);
        this.replaceAir(worldgenlevel, blockpos.offset(2, -1, 0), material);
        this.replaceAir(worldgenlevel, blockpos.offset(2, -1, 1), material);
        this.replaceAir(worldgenlevel, blockpos.offset(-1, -1, -2), material);
        this.replaceAir(worldgenlevel, blockpos.offset(0, -1, -2), material);
        this.replaceAir(worldgenlevel, blockpos.offset(1, -1, -2), material);
        this.replaceAir(worldgenlevel, blockpos.offset(-1, -1, 2), material);
        this.replaceAir(worldgenlevel, blockpos.offset(0, -1, 2), material);
        this.replaceAir(worldgenlevel, blockpos.offset(1, -1, 2), material);
        int randomNumber = (int)(Math.random() * 6.0 + 1.0);
        if (randomNumber < 2) {
            worldgenlevel.setBlock(blockpos.offset(-3, -1, -1), material, 2);
            worldgenlevel.setBlock(blockpos.offset(-3, -1, 0), material, 2);
            worldgenlevel.setBlock(blockpos.offset(-3, -1, 1), material, 2);
            worldgenlevel.setBlock(blockpos.offset(-2, -1, 0), water, 2);
            worldgenlevel.setBlock(blockpos.offset(2, 0, 0), this.randomSapling(), 2);
            worldgenlevel.setBlock(blockpos.offset(0, 0, 2), this.randomSapling(), 2);
            worldgenlevel.setBlock(blockpos.offset(0, 0, -2), this.randomSapling(), 2);
        } else if (randomNumber < 3) {
            worldgenlevel.setBlock(blockpos.offset(3, -1, -1), material, 2);
            worldgenlevel.setBlock(blockpos.offset(3, -1, 0), material, 2);
            worldgenlevel.setBlock(blockpos.offset(3, -1, 1), material, 2);
            worldgenlevel.setBlock(blockpos.offset(2, -1, 0), water, 2);
            worldgenlevel.setBlock(blockpos.offset(-2, 0, 0), this.randomSapling(), 2);
            worldgenlevel.setBlock(blockpos.offset(0, 0, 2), this.randomSapling(), 2);
            worldgenlevel.setBlock(blockpos.offset(0, 0, -2), this.randomSapling(), 2);
        } else if (randomNumber < 4) {
            worldgenlevel.setBlock(blockpos.offset(-1, -1, -3), material, 2);
            worldgenlevel.setBlock(blockpos.offset(0, -1, -3), material, 2);
            worldgenlevel.setBlock(blockpos.offset(1, -1, -3), material, 2);
            worldgenlevel.setBlock(blockpos.offset(0, -1, -2), water, 2);
            worldgenlevel.setBlock(blockpos.offset(2, 0, 0), this.randomSapling(), 2);
            worldgenlevel.setBlock(blockpos.offset(0, 0, 2), this.randomSapling(), 2);
            worldgenlevel.setBlock(blockpos.offset(-2, 0, 0), this.randomSapling(), 2);
        } else if (randomNumber < 5) {
            worldgenlevel.setBlock(blockpos.offset(-1, -1, 3), material, 2);
            worldgenlevel.setBlock(blockpos.offset(0, -1, 3), material, 2);
            worldgenlevel.setBlock(blockpos.offset(1, -1, 3), material, 2);
            worldgenlevel.setBlock(blockpos.offset(0, -1, 2), water, 2);
            worldgenlevel.setBlock(blockpos.offset(2, 0, 0), this.randomSapling(), 2);
            worldgenlevel.setBlock(blockpos.offset(-2, 0, 0), this.randomSapling(), 2);
            worldgenlevel.setBlock(blockpos.offset(0, 0, -2), this.randomSapling(), 2);
        } else if (randomNumber < 6) {
            worldgenlevel.setBlock(blockpos.offset(-1, -1, -3), material, 2);
            worldgenlevel.setBlock(blockpos.offset(0, -1, -3), material, 2);
            worldgenlevel.setBlock(blockpos.offset(1, -1, -3), material, 2);
            worldgenlevel.setBlock(blockpos.offset(0, -1, -2), water, 2);
            worldgenlevel.setBlock(blockpos.offset(3, -1, -1), material, 2);
            worldgenlevel.setBlock(blockpos.offset(3, -1, 0), material, 2);
            worldgenlevel.setBlock(blockpos.offset(3, -1, 1), material, 2);
            worldgenlevel.setBlock(blockpos.offset(2, -1, 0), water, 2);
            worldgenlevel.setBlock(blockpos.offset(-2, 0, 0), this.randomSapling(), 2);
            worldgenlevel.setBlock(blockpos.offset(0, 0, 2), this.randomSapling(), 2);
        } else if (randomNumber < 7) {
            worldgenlevel.setBlock(blockpos.offset(-1, -1, 3), material, 2);
            worldgenlevel.setBlock(blockpos.offset(0, -1, 3), material, 2);
            worldgenlevel.setBlock(blockpos.offset(1, -1, 3), material, 2);
            worldgenlevel.setBlock(blockpos.offset(0, -1, 2), water, 2);
            worldgenlevel.setBlock(blockpos.offset(-3, -1, -1), material, 2);
            worldgenlevel.setBlock(blockpos.offset(-3, -1, 0), material, 2);
            worldgenlevel.setBlock(blockpos.offset(-3, -1, 1), material, 2);
            worldgenlevel.setBlock(blockpos.offset(-2, -1, 0), water, 2);
            worldgenlevel.setBlock(blockpos.offset(2, 0, 0), this.randomSapling(), 2);
            worldgenlevel.setBlock(blockpos.offset(0, 0, -2), this.randomSapling(), 2);
        }
        int randomNumber2 = (int)(Math.random() * 6.0 + 1.0);
        if (randomNumber2 < 3) {
            this.generateCorner(worldgenlevel, blockpos.offset(-1, -1, -1), material, slab);
        } else if (randomNumber2 < 4) {
            this.generateCorner(worldgenlevel, blockpos.offset(1, -1, -1), material, slab);
            this.generateCorner(worldgenlevel, blockpos.offset(-1, -1, 1), material, slab);
        } else if (randomNumber2 < 5) {
            this.generateCorner(worldgenlevel, blockpos.offset(1, -1, 1), material, slab);
        } else if (randomNumber2 < 6) {
            this.generateCorner(worldgenlevel, blockpos.offset(-1, -1, -1), material, slab);
            this.generateCorner(worldgenlevel, blockpos.offset(1, -1, 1), material, slab);
        } else if (randomNumber2 < 7) {
            this.generateCorner(worldgenlevel, blockpos.offset(1, -1, -1), material, slab);
            this.generateCorner(worldgenlevel, blockpos.offset(1, -1, 1), material, slab);
        }
        return true;
    }

    private void replaceAir(WorldGenLevel worldGenLevel, BlockPos blockPos, BlockState material) {
        if (!worldGenLevel.getBlockState(blockPos).isSolid()) {
            worldGenLevel.setBlock(blockPos, material, 2);
        }
    }

    private void generateCorner(WorldGenLevel worldGenLevel, BlockPos blockPos, BlockState material, BlockState slab) {
        int randomNumber2;
        worldGenLevel.setBlock(blockPos, material, 2);
        worldGenLevel.setBlock(blockPos.above(), material, 2);
        int randomNumber = (int)(Math.random() * 3.0 + 1.0);
        if (randomNumber < 3) {
            this.replaceAir(worldGenLevel, blockPos.above(2), Blocks.MOSS_CARPET.defaultBlockState());
        }
        if ((randomNumber2 = (int)(Math.random() * 4.0 + 1.0)) < 2) {
            this.generateExtension(worldGenLevel, blockPos.north(), material, slab);
        }
    }

    private void generateExtension(WorldGenLevel worldGenLevel, BlockPos blockPos, BlockState material, BlockState slab) {
        worldGenLevel.setBlock(blockPos, material, 2);
        int randomNumber = (int)(Math.random() * 3.0 + 1.0);
        if (randomNumber < 2) {
            this.replaceAir(worldGenLevel, blockPos.above(), slab);
        } else if (randomNumber < 3) {
            worldGenLevel.setBlock(blockPos.above(), material, 2);
            this.generateExtensionDecor(worldGenLevel, blockPos.above(2));
        } else {
            this.generateExtensionDecor(worldGenLevel, blockPos.above());
        }
    }

    private void generateExtensionDecor(WorldGenLevel worldGenLevel, BlockPos blockPos) {
        int randomNumber = (int)(Math.random() * 2.0 + 1.0);
        if (randomNumber < 2) {
            int randomNumber2 = (int)(Math.random() * 3.0 + 1.0);
            if (randomNumber2 < 2) {
                this.replaceAir(worldGenLevel, blockPos, Blocks.MOSS_CARPET.defaultBlockState());
            } else {
                this.replaceAir(worldGenLevel, blockPos, this.randomSapling());
            }
        }
    }

    private BlockState randomSapling() {
        int randomNumber = (int)(Math.random() * 15.0 + 1.0);
        if (randomNumber < 2) {
            return Blocks.OAK_SAPLING.defaultBlockState();
        }
        if (randomNumber < 3) {
            return Blocks.BIRCH_SAPLING.defaultBlockState();
        }
        if (randomNumber < 4) {
            return Blocks.SPRUCE_SAPLING.defaultBlockState();
        }
        if (randomNumber < 5) {
            return Blocks.ACACIA_SAPLING.defaultBlockState();
        }
        if (randomNumber < 6) {
            return Blocks.DARK_OAK_SAPLING.defaultBlockState();
        }
        if (randomNumber < 7) {
            return Blocks.JUNGLE_SAPLING.defaultBlockState();
        }
        if (randomNumber < 8) {
            return Blocks.CHERRY_SAPLING.defaultBlockState();
        }
        if (randomNumber < 9) {
            return Blocks.RED_MUSHROOM.defaultBlockState();
        }
        if (randomNumber < 10) {
            return Blocks.BROWN_MUSHROOM.defaultBlockState();
        }
        return (BlockState)Blocks.LARGE_FERN.defaultBlockState().setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.UPPER);
    }
}

