/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.blocks.PileOfPollen;
import com.telepathicgrunt.the_bumblezone.blocks.StateReturningBrushableBlock;
import com.telepathicgrunt.the_bumblezone.blocks.blockentities.StateFocusedBrushableBlockEntity;
import com.telepathicgrunt.the_bumblezone.mixin.entities.EntityCollisionContextAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzParticles;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import com.telepathicgrunt.the_bumblezone.utils.PlatformHooks;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Panda;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BrushItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BrushableBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PileOfPollenSuspicious
extends BrushableBlock
implements StateReturningBrushableBlock {
    protected static final VoxelShape SHAPE = Shapes.block();
    private Item item;
    public static final MapCodec<? extends PileOfPollenSuspicious> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("turns_into").forGetter(PileOfPollenSuspicious::getTurnsInto), (App)BuiltInRegistries.SOUND_EVENT.byNameCodec().fieldOf("brush_sound").forGetter(BrushableBlock::getBrushSound), (App)BuiltInRegistries.SOUND_EVENT.byNameCodec().fieldOf("brush_comleted_sound").forGetter(BrushableBlock::getBrushCompletedSound), (App)PileOfPollenSuspicious.propertiesCodec()).apply((Applicative)instance, PileOfPollenSuspicious::new));

    public PileOfPollenSuspicious() {
        this(null, SoundEvents.BRUSH_SAND, SoundEvents.BRUSH_SAND_COMPLETED, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).isViewBlocking((blockState, world, blockPos) -> true).isSuffocating((blockState, blockGetter, blockPos) -> false).noOcclusion().noCollission().strength(0.1f).pushReaction(PushReaction.DESTROY).sound(SoundType.SNOW));
    }

    public PileOfPollenSuspicious(Block block, SoundEvent soundEvent1, SoundEvent soundEvent2, BlockBehaviour.Properties properties) {
        super(block, soundEvent1, soundEvent2, properties);
    }

    public MapCodec<BrushableBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new StateFocusedBrushableBlockEntity(blockPos, blockState);
    }

    public Block getTurnsInto() {
        return (Block)BzBlocks.PILE_OF_POLLEN.get();
    }

    @Override
    public BlockState getTurnsIntoState() {
        return (BlockState)((Block)BzBlocks.PILE_OF_POLLEN.get()).defaultBlockState().setValue((Property)PileOfPollen.LAYERS, (Comparable)Integer.valueOf(8));
    }

    public ItemStack getCloneItemStack(LevelReader world, BlockPos blockPos, BlockState blockState) {
        return new ItemStack((ItemLike)BzItems.POLLEN_PUFF.get());
    }

    public Item asItem() {
        if (this.item == null) {
            this.item = (Item)BzItems.POLLEN_PUFF.get();
        }
        return this.item;
    }

    protected boolean isPathfindable(BlockState blockState, PathComputationType pathComputationType) {
        return true;
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter world, BlockPos blockPos, CollisionContext selectionContext) {
        return SHAPE;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        EntityCollisionContext ctx;
        Entity entity;
        if (context instanceof EntityCollisionContext && (entity = (ctx = (EntityCollisionContext)context).getEntity()) != null && entity.getType() != BzEntities.POLLEN_PUFF_ENTITY.get()) {
            StackTraceElement[] stackTrace;
            boolean found;
            context.isHoldingItem(Items.AIR);
            ItemStack heldItem = ((EntityCollisionContextAccessor)ctx).bumblezone$getHeldItem();
            if (heldItem != null && !heldItem.isEmpty() && (PlatformHooks.isItemAbility(heldItem, BrushItem.class, "brush_brush") || heldItem.is(BzTags.SUSPICIOUS_PILE_OF_POLLEN_ADDITIONAL_BRUSHES)) && (found = Arrays.stream(stackTrace = Thread.currentThread().getStackTrace()).map(StackTraceElement::getClassName).anyMatch(c -> c.equals(Items.BRUSH.getClass().getName()) || c.equals(heldItem.getItem().getClass().getName())))) {
                return this.getShape(state, worldIn, pos, context);
            }
            return Shapes.empty();
        }
        return this.getShape(state, worldIn, pos, context);
    }

    public VoxelShape getBlockSupportShape(BlockState blockState, BlockGetter world, BlockPos blockPos) {
        return SHAPE;
    }

    public VoxelShape getVisualShape(BlockState blockState, BlockGetter world, BlockPos blockPos, CollisionContext selectionContext) {
        return SHAPE;
    }

    public boolean useShapeForLightOcclusion(BlockState blockState) {
        return true;
    }

    public boolean canSurvive(BlockState blockState, LevelReader world, BlockPos blockPos) {
        BlockState blockstate = world.getBlockState(blockPos.below());
        if (blockstate.is(BlockTags.SNOW_LAYER_CANNOT_SURVIVE_ON) || !world.getBlockState(blockPos).getFluidState().isEmpty()) {
            return false;
        }
        if (blockstate.isAir() || blockstate.is(BzTags.POLLEN_BLOCKS) || blockstate.is(BlockTags.SNOW_LAYER_CAN_SURVIVE_ON)) {
            return true;
        }
        return GeneralUtils.isFaceFullFast(blockstate.getCollisionShape((BlockGetter)world, blockPos.below()), Direction.UP);
    }

    public void tick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        BlockState belowState;
        BlockEntity blockEntity = serverLevel.getBlockEntity(blockPos);
        if (blockEntity instanceof BrushableBlockEntity) {
            BrushableBlockEntity brushableBlockEntity = (BrushableBlockEntity)blockEntity;
            brushableBlockEntity.checkReset();
        }
        if (!FallingBlock.isFree((BlockState)(belowState = serverLevel.getBlockState(blockPos.below()))) || belowState.is((Block)BzBlocks.PILE_OF_POLLEN.get()) && (Integer)belowState.getValue((Property)PileOfPollen.LAYERS) == 8 || blockPos.getY() < serverLevel.getMinBuildHeight()) {
            return;
        }
        FallingBlockEntity fallingBlockEntity = FallingBlockEntity.fall((Level)serverLevel, (BlockPos)blockPos, (BlockState)blockState);
        fallingBlockEntity.disableDrop();
    }

    public BlockState updateShape(BlockState oldBlockState, Direction direction, BlockState newBlockState, LevelAccessor world, BlockPos blockPos, BlockPos blockPos1) {
        return !oldBlockState.canSurvive((LevelReader)world, blockPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(oldBlockState, direction, newBlockState, world, blockPos, blockPos1);
    }

    public void destroy(LevelAccessor world, BlockPos blockPos, BlockState blockState) {
        if (world.isClientSide()) {
            for (int i = 0; i < 50; ++i) {
                PileOfPollenSuspicious.spawnParticles(blockState, world, blockPos, world.getRandom(), true);
                PileOfPollenSuspicious.spawnParticles(world, Vec3.atCenterOf((Vec3i)blockPos), world.getRandom(), 0.055, 0.0075, 0.0);
            }
        }
    }

    public void entityInside(BlockState blockState, Level world, BlockPos blockPos, Entity entity) {
        if (!blockState.is((Block)BzBlocks.PILE_OF_POLLEN_SUSPICIOUS.get())) {
            return;
        }
        if (!(entity instanceof ExperienceOrb)) {
            int layerValueMinusOne = 7;
            double entitySpeed = entity.getDeltaMovement().length();
            double chance = 0.22 + (double)layerValueMinusOne * 0.09;
            Pair reduction = PileOfPollen.APPLIED_FALL_REDUCTION_FOR_ENTITY.getOrDefault(entity.getStringUUID(), null);
            if (reduction == null || (Integer)reduction.getFirst() != entity.tickCount || (Integer)reduction.getSecond() < layerValueMinusOne && (Integer)reduction.getFirst() == entity.tickCount) {
                int diffInLayer = reduction == null ? layerValueMinusOne : layerValueMinusOne - (Integer)reduction.getSecond();
                PileOfPollen.slowFallSpeed(entity, blockPos, diffInLayer);
                PileOfPollen.APPLIED_FALL_REDUCTION_FOR_ENTITY.put(entity.getStringUUID(), (Pair<Integer, Integer>)Pair.of((Object)entity.tickCount, (Object)layerValueMinusOne));
            }
            if (entitySpeed > 1.0E-5 && (double)world.random.nextFloat() < chance) {
                int particleStrength;
                int particleNumber = (int)(entitySpeed / 0.0045);
                int n = particleStrength = entity instanceof ItemEntity ? Math.min(10, particleNumber / 3) : Math.min(20, particleNumber);
                if (world.isClientSide()) {
                    for (int i = 0; i < particleNumber; ++i) {
                        if (particleNumber > 5) {
                            PileOfPollenSuspicious.spawnParticles(blockState, (LevelAccessor)world, blockPos, world.random, true);
                        }
                        PileOfPollenSuspicious.spawnParticles((LevelAccessor)world, entity.position().add(entity.getDeltaMovement().multiply(2.0, 2.0, 2.0)).add(0.0, 0.75, 0.0), world.random, 0.006 * (double)particleStrength, 7.5E-4 * (double)particleStrength, 0.006 * (double)particleStrength);
                    }
                } else if (!(entity instanceof Player) && !(entity instanceof ItemEntity)) {
                    PileOfPollenSuspicious.spawnParticlesServer((LevelAccessor)world, entity.position().add(entity.getDeltaMovement().multiply(2.0, 2.0, 2.0)).add(0.0, 0.75, 0.0), world.random, 0.006 * (double)particleStrength, 7.5E-4 * (double)particleStrength, 0.006 * (double)particleStrength, particleNumber);
                }
            }
            if (entity instanceof Panda) {
                Panda pandaEntity = (Panda)entity;
                PileOfPollenSuspicious.pandaSneezing(pandaEntity);
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                PileOfPollen.applyHiddenEffectIfBuried(livingEntity, blockState, blockPos, true);
            }
        }
    }

    public static void pandaSneezing(Panda pandaEntity) {
        if (!pandaEntity.level().isClientSide() && pandaEntity.getRandom().nextFloat() < 0.005f && pandaEntity.level().getBlockState(pandaEntity.blockPosition()).is((Block)BzBlocks.PILE_OF_POLLEN.get())) {
            pandaEntity.sneeze(true);
        }
    }

    public void animateTick(BlockState blockState, Level world, BlockPos blockPos, RandomSource random) {
        double chance = 0.08f;
        if ((double)random.nextFloat() < chance) {
            PileOfPollenSuspicious.spawnParticles(blockState, (LevelAccessor)world, blockPos, random, false);
        }
    }

    public static void spawnParticles(BlockState blockState, LevelAccessor world, BlockPos blockPos, RandomSource random, boolean disturbed) {
        for (Direction direction : Direction.values()) {
            BlockPos blockpos = blockPos.relative(direction);
            if (world.getBlockState(blockpos).isSolidRender((BlockGetter)world, blockpos)) continue;
            double speedYModifier = disturbed ? 0.05 : 0.005;
            double speedXZModifier = disturbed ? 0.03 : 0.005;
            VoxelShape currentShape = SHAPE;
            double yHeight = currentShape.max(Direction.Axis.Y) - currentShape.min(Direction.Axis.Y);
            Direction.Axis directionAxis = direction.getAxis();
            double xOffset = directionAxis == Direction.Axis.X ? 0.5 + 0.5625 * (double)direction.getStepX() : (double)random.nextFloat();
            double yOffset = directionAxis == Direction.Axis.Y ? yHeight * (double)direction.getStepY() : (double)random.nextFloat() * yHeight;
            double zOffset = directionAxis == Direction.Axis.Z ? 0.5 + 0.5625 * (double)direction.getStepZ() : (double)random.nextFloat();
            world.addParticle((ParticleOptions)BzParticles.POLLEN_PARTICLE.get(), (double)blockPos.getX() + xOffset, (double)blockPos.getY() + yOffset, (double)blockPos.getZ() + zOffset, random.nextGaussian() * speedXZModifier, random.nextGaussian() * speedYModifier + (disturbed ? 0.01 : 0.0), random.nextGaussian() * speedXZModifier);
            return;
        }
    }

    public static void spawnParticles(LevelAccessor world, Vec3 location, RandomSource random, double speedXZModifier, double speedYModifier, double initYSpeed) {
        double xOffset = (double)random.nextFloat() * 0.3 - 0.15;
        double yOffset = (double)random.nextFloat() * 0.3 - 0.15;
        double zOffset = (double)random.nextFloat() * 0.3 - 0.15;
        world.addParticle((ParticleOptions)BzParticles.POLLEN_PARTICLE.get(), location.x() + xOffset, location.y() + yOffset, location.z() + zOffset, random.nextGaussian() * speedXZModifier, random.nextGaussian() * speedYModifier + initYSpeed, random.nextGaussian() * speedXZModifier);
    }

    public static void spawnParticlesServer(LevelAccessor world, Vec3 location, RandomSource random, double speedXZModifier, double speedYModifier, double initYSpeed, int numberOfParticles) {
        if (world.isClientSide()) {
            return;
        }
        double xOffset = (double)random.nextFloat() * 0.3 - 0.15;
        double yOffset = (double)random.nextFloat() * 0.3 - 0.15;
        double zOffset = (double)random.nextFloat() * 0.3 - 0.15;
        ((ServerLevel)world).sendParticles((ParticleOptions)((SimpleParticleType)BzParticles.POLLEN_PARTICLE.get()), location.x() + xOffset, location.y() + yOffset, location.z() + zOffset, numberOfParticles, random.nextGaussian() * speedXZModifier, random.nextGaussian() * speedYModifier + initYSpeed, random.nextGaussian() * speedXZModifier, (double)0.02f);
    }
}

