/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.controllers;

import com.telepathicgrunt.the_bumblezone.entities.mobs.BeehemothEntity;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.phys.Vec3;

public class BeehemothMoveController
extends MoveControl {
    private final BeehemothEntity beehemothEntity;

    public BeehemothMoveController(BeehemothEntity beehemothEntity) {
        super((Mob)beehemothEntity);
        this.beehemothEntity = beehemothEntity;
    }

    public void tick() {
        Vec3 vec3;
        if (this.operation == MoveControl.Operation.STRAFE) {
            vec3 = new Vec3(this.wantedX - this.beehemothEntity.getX(), this.wantedY - this.beehemothEntity.getY(), this.wantedZ - this.beehemothEntity.getZ());
            double d0 = vec3.length();
            this.beehemothEntity.setDeltaMovement(this.beehemothEntity.getDeltaMovement().add(0.0, vec3.scale(this.speedModifier * 0.05 / d0).y(), 0.0));
            float f = (float)this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED);
            float f1 = (float)this.speedModifier * f;
            this.strafeForwards = 1.0f;
            this.strafeRight = 0.0f;
            this.mob.setSpeed(f1);
            this.mob.setZza(this.strafeForwards);
            this.mob.setXxa(this.strafeRight);
            this.operation = MoveControl.Operation.WAIT;
        }
        if (this.operation == MoveControl.Operation.MOVE_TO) {
            vec3 = new Vec3(this.wantedX - this.beehemothEntity.getX(), this.wantedY - this.beehemothEntity.getY(), this.wantedZ - this.beehemothEntity.getZ());
            double length = vec3.length() / 1.25;
            if (length < this.beehemothEntity.getBoundingBox().getSize()) {
                this.operation = MoveControl.Operation.WAIT;
                this.beehemothEntity.setDeltaMovement(this.beehemothEntity.getDeltaMovement().scale(0.5));
            } else {
                double localSpeed = this.speedModifier;
                if (this.beehemothEntity.isVehicle()) {
                    localSpeed *= 1.5;
                }
                Vec3 newVelocity = this.beehemothEntity.getDeltaMovement().add(vec3.scale(localSpeed / length));
                double newYSpeed = this.beehemothEntity.onGround() ? newVelocity.y() + 0.009 : newVelocity.y();
                this.beehemothEntity.setDeltaMovement(newVelocity.x(), newYSpeed, newVelocity.z());
                float lookAngle = (float)(Mth.atan2((double)vec3.x(), (double)vec3.z()) * -57.2957763671875);
                this.beehemothEntity.setYRot(this.rotlerp(this.beehemothEntity.getYRot(), lookAngle, 90.0f));
            }
        }
    }
}

