/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.component.button;

import com.nine.travelerscompass.client.ClientData;
import com.nine.travelerscompass.client.component.button.BaseButton;
import com.nine.travelerscompass.client.hud.HudData;
import com.nine.travelerscompass.client.utils.ClientUtils;
import com.nine.travelerscompass.client.utils.SearchProgress;
import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.search.location.ILocationObject;
import com.nine.travelerscompass.common.utils.FoundBlockPos;
import com.nine.travelerscompass.common.utils.SearchState;
import java.util.ArrayList;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class InfoButton
extends BaseButton {
    private final Supplier<ItemStack> supplier;
    private final UUID uuid;

    public InfoButton(int x, int y, int width, int height, Supplier<ItemStack> supplier) {
        super(x, y, width, height);
        this.supplier = supplier;
        this.uuid = CompassProperties.COMPASS_UUID.get(supplier.get());
        this.refreshTooltip();
    }

    @Override
    public void refreshTooltip() {
        MutableComponent status;
        MutableComponent title = Component.translatable((String)"tooltip.travelerscompass.settings.info");
        ArrayList<Component> components = new ArrayList<Component>();
        ItemStack stack = this.supplier.get();
        FoundBlockPos pos = CompassProperties.FOUND_BLOCK_POS.get(stack);
        SearchState state = CompassProperties.SEARCH_STATE.get(stack);
        if (CompassProperties.PAUSE.get(stack).booleanValue()) {
            status = Component.translatable((String)"tooltip.travelerscompass.settings.info.status.paused").withStyle(ChatFormatting.GRAY);
        } else if (state == SearchState.SEARCHING) {
            SearchProgress searchProgress = ClientData.PROGRESS_DATA_CACHE.get(this.uuid);
            int percent = 0;
            if (searchProgress != null) {
                percent = searchProgress.progress * 100 / searchProgress.total;
            }
            MutableComponent progress = ClientUtils.coloredComponent(Component.literal((String)(percent + "%")), 0xC8C8C8);
            status = pos.isValid() ? Component.translatable((String)"tooltip.travelerscompass.settings.info.status.scanning", (Object[])new Object[]{progress}).withStyle(ChatFormatting.GRAY) : Component.translatable((String)"tooltip.travelerscompass.settings.info.status.searching", (Object[])new Object[]{progress}).withStyle(ChatFormatting.GRAY);
        } else {
            status = Component.translatable((String)"tooltip.travelerscompass.settings.info.status.idle").withStyle(ChatFormatting.GRAY);
        }
        MutableComponent statusFull = Component.translatable((String)"tooltip.travelerscompass.settings.info.status", (Object[])new Object[]{status});
        components.add((Component)title);
        components.add((Component)statusFull);
        HudData data = ClientData.HUD_DATA_CACHE.get(CompassProperties.COMPASS_UUID.get(stack));
        if (data != null) {
            ILocationObject locationObject = data.getLocationObject();
            if (pos.isValid() && locationObject != null) {
                MutableComponent target = Component.translatable((String)"tooltip.travelerscompass.settings.info.target", (Object[])new Object[]{Component.translatable((String)locationObject.descriptionId()).withStyle(ChatFormatting.GRAY)}).withStyle(ChatFormatting.WHITE);
                components.add((Component)target);
                if (locationObject.blockPos() != null) {
                    BlockPos blockPos = pos.blockPos();
                    MutableComponent position = Component.translatable((String)"tooltip.travelerscompass.settings.info.position", (Object[])new Object[]{Component.literal((String)(blockPos.getX() + ", " + blockPos.getY() + ", " + blockPos.getZ())).withStyle(ChatFormatting.GRAY)}).withStyle(ChatFormatting.WHITE);
                    components.add((Component)position);
                }
            }
        }
        this.setTooltip(Tooltip.create((Component)ClientUtils.buildTooltip(components)));
    }

    @Override
    protected void renderMainLayer(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        ClientUtils.renderTexture(graphics, ClientData.TOGGLE_BUTTON.get(false, this.isHovered()), this.getX(), this.getY());
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWidget(graphics, mouseX, mouseY, partialTicks);
        ClientUtils.renderTexture(graphics, this.isHovered() ? ClientData.INFO_HOVERED : ClientData.INFO, this.getX() + 4, this.getY() + 3);
    }
}

