/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.component.button;

import com.nine.travelerscompass.client.ClientData;
import com.nine.travelerscompass.client.component.button.BaseButton;
import com.nine.travelerscompass.client.utils.ClientUtils;
import com.nine.travelerscompass.client.utils.IconTexture;
import com.nine.travelerscompass.client.utils.RangeUtils;
import com.nine.travelerscompass.client.utils.TextureData;
import com.nine.travelerscompass.common.data.DataStorage;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class RangeButton<T extends Number>
extends BaseButton
implements RangeUtils.RangeButtonHandler<T> {
    private final IconTexture PLUS = new IconTexture(ClientData.PLUS, 3, 3);
    private final IconTexture PLUS_INACTIVE = new IconTexture(ClientData.PLUS_INACTIVE, 3, 3);
    private final IconTexture PLUS_CTRL = new IconTexture(ClientData.PLUS_HOVERED, 3, 3);
    private final IconTexture MINUS = new IconTexture(ClientData.MINUS, 3, 3);
    private final IconTexture MINUS_INACTIVE = new IconTexture(ClientData.MINUS_INACTIVE, 3, 3);
    private final IconTexture MINUS_CTRL = new IconTexture(ClientData.MINUS_HOVERED, 3, 3);
    private final IconTexture icon;
    private final Supplier<ItemStack> supplier;
    private final DataStorage<T> data;
    private final T min;
    private final T max;
    private final RangeUtils.RangeAdapter<T> adapter;
    private T cached;

    public RangeButton(int x, int y, int width, int height, T minValue, T maxValue, RangeUtils.RangeAdapter<T> adapter, IconTexture textureData, DataStorage<T> data, Supplier<ItemStack> supplier) {
        super(x, y, width, height);
        this.data = data;
        this.supplier = supplier;
        this.min = minValue;
        this.max = maxValue;
        this.adapter = adapter;
        this.icon = textureData;
        this.updateState();
    }

    @Override
    public T current() {
        return this.cached;
    }

    @Override
    public void set(T value) {
        this.data.sendToServer(this.supplier.get(), value);
    }

    @Override
    public T min() {
        return this.min;
    }

    @Override
    public T max() {
        return this.max;
    }

    @Override
    public RangeUtils.RangeAdapter<T> adapter() {
        return this.adapter;
    }

    public void onClick(double mouseX, double mouseY) {
        boolean changed = RangeUtils.changeValue(this, this.shiftPressed, this.ctrlPressed);
        if (changed) {
            this.updateState();
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        boolean changed = RangeUtils.changeValue(this, scrollY < 0.0, this.ctrlPressed);
        if (changed) {
            this.updateState();
        }
        return changed && super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public void updateState() {
        ItemStack stack = this.supplier.get();
        this.cached = (Number)this.data.get(stack);
        this.refreshTooltip();
    }

    public void renderIcon(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks, boolean outOfBounds) {
        IconTexture result;
        int xOff = 2;
        if (this.isHovered) {
            result = this.shiftPressed ? (outOfBounds ? this.MINUS_INACTIVE : (this.ctrlPressed ? this.MINUS_CTRL : this.MINUS)) : (outOfBounds ? this.PLUS_INACTIVE : (this.ctrlPressed ? this.PLUS_CTRL : this.PLUS));
            xOff = 3;
        } else {
            result = this.icon;
        }
        ClientUtils.renderTexture(graphics, result, this.getX(), this.getY());
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWidget(graphics, mouseX, mouseY, partialTicks);
        boolean outOfBounds = RangeUtils.isOutOfBounds(this, this.adapter().add(this.cached, (this.ctrlPressed ? 5 : 1) * (this.shiftPressed ? -1 : 1)));
        TextureData baseLayer = ClientData.TOGGLE_BUTTON.get(false, this.isHovered(), !outOfBounds || !this.isHovered);
        ClientUtils.renderTexture(graphics, baseLayer, this.getX(), this.getY());
        this.renderIcon(graphics, mouseX, mouseY, partialTicks, outOfBounds);
    }

    @Override
    public void refreshTooltip() {
        ArrayList<Component> components = new ArrayList<Component>();
        components.add((Component)Component.translatable((String)("tooltip.travelerscompass.settings." + this.data.id())).withStyle(ChatFormatting.WHITE));
        MutableComponent shift = ClientUtils.coloredComponent(Component.translatable((String)"tooltip.travelerscompass.settings.modification.shift"), this.shiftPressed ? 0xAAAAAA : 0xC8C8C8);
        MutableComponent ctrl = ClientUtils.coloredComponent(Component.translatable((String)"tooltip.travelerscompass.settings.modification.ctrl"), this.ctrlPressed ? 0xAAAAAA : 0xC8C8C8);
        components.add((Component)Component.translatable((String)"tooltip.travelerscompass.settings.modification.hold_to_decrease", (Object[])new Object[]{shift}).withStyle(ChatFormatting.GRAY));
        components.add((Component)Component.translatable((String)"tooltip.travelerscompass.settings.modification.hold_to_change_faster", (Object[])new Object[]{ctrl}).withStyle(ChatFormatting.GRAY));
        if (this.shiftPressed) {
            MutableComponent desc = Component.empty().append(ClientUtils.DESC_ARROW).append((Component)Component.translatable((String)("tooltip.travelerscompass.settings." + this.data.id() + ".desc")).withStyle(ChatFormatting.GRAY));
            components.add((Component)desc);
        }
        MutableComponent value = Component.literal((String)String.valueOf(this.cached));
        ClientUtils.setColor(value, 0xC8C8C8);
        components.add((Component)Component.translatable((String)("tooltip.travelerscompass.settings." + this.data.id() + ".value"), (Object[])new Object[]{value}).withStyle(ChatFormatting.GRAY));
        this.setTooltip(Tooltip.create((Component)ClientUtils.buildTooltip(components)));
    }
}

