/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.component.button;

import com.nine.travelerscompass.client.ClientData;
import com.nine.travelerscompass.client.component.button.ToggleButton;
import com.nine.travelerscompass.client.component.button.Toggleable;
import com.nine.travelerscompass.client.utils.ClientUtils;
import com.nine.travelerscompass.client.utils.IconTexture;
import com.nine.travelerscompass.client.utils.TextureData;
import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.data.DataStorage;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class SearchModeButton
extends ToggleButton {
    private final DataStorage<Boolean> data;
    protected final IconTexture iconInactive;
    protected final IconTexture iconActive;
    private final ItemStack stack;
    private final boolean enabled;

    public SearchModeButton(int x, int y, int width, int height, boolean enabled, DataStorage<Boolean> data, IconTexture iconActive, IconTexture iconInactive, ItemStack stack) {
        super(x, y, width, height, ClientData.TOGGLE_BUTTON);
        this.data = data;
        this.stack = stack;
        this.iconActive = iconActive;
        this.iconInactive = iconInactive;
        this.enabled = enabled;
        this.active = enabled;
        this.setToggled(data.get(stack));
        this.refreshTooltip();
    }

    public void onClick(double mouseX, double mouseY) {
        CompassProperties.toggleToServer(this.stack, this.data, true);
        this.setToggled(this.data.get(this.stack));
        this.refreshTooltip();
    }

    @Override
    protected TextureData getBaseLayer() {
        return this.buttonTextures.get(this.toggled, this.isHovered, this.enabled);
    }

    @Override
    public void refreshTooltip() {
        Component state;
        ArrayList<Component> list = new ArrayList<Component>();
        String key = "tooltip.travelerscompass.search_mode." + this.data.id();
        MutableComponent title = Component.translatable((String)key);
        list.add((Component)title);
        if (this.enabled) {
            Component component = state = this.isToggled() ? Toggleable.ENABLED : Toggleable.DISABLED;
            if (this.shiftPressed) {
                list.add((Component)Component.empty().append(ClientUtils.DESC_ARROW).append((Component)Component.translatable((String)(key + ".desc")).withStyle(ChatFormatting.GRAY)));
            }
        } else {
            state = Toggleable.CONFIG_DISABLED;
        }
        list.add(state);
        this.setTooltip(Tooltip.create((Component)ClientUtils.buildTooltip(list)));
    }

    @Override
    public void renderIcon(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        IconTexture icon = this.isToggled() ? this.iconActive : this.iconInactive;
        ClientUtils.renderTexture(graphics, icon, this.getX(), this.getY());
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWidget(graphics, mouseX, mouseY, partialTicks);
        if (this.enabled) {
            this.renderIcon(graphics, mouseX, mouseY, partialTicks);
        } else {
            TextureData lock = ClientData.LOCK;
            ClientUtils.renderTexture(graphics, lock, this.getX() + 3, this.getY() + 2);
        }
    }
}

