/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.component.element;

import com.nine.travelerscompass.client.ClientData;
import com.nine.travelerscompass.client.component.element.NewPopupElement;
import com.nine.travelerscompass.client.utils.ClientUtils;
import com.nine.travelerscompass.client.utils.IconTexture;
import com.nine.travelerscompass.client.utils.RangeUtils;
import com.nine.travelerscompass.client.utils.TextureData;
import com.nine.travelerscompass.common.data.DataStorage;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class NewRangePopupElement<T extends Number>
extends NewPopupElement
implements RangeUtils.RangeButtonHandler<T> {
    public static final IconTexture PLUS = new IconTexture(ClientData.PLUS_SMALL, 2, 2);
    public static final IconTexture PLUS_INACTIVE = new IconTexture(ClientData.PLUS_SMALL_INACTIVE, 2, 2);
    public static final IconTexture PLUS_CTRL = new IconTexture(ClientData.PLUS_SMALL_HOVERED, 2, 2);
    public static final IconTexture MINUS = new IconTexture(ClientData.MINUS_SMALL, 2, 2);
    public static final IconTexture MINUS_INACTIVE = new IconTexture(ClientData.MINUS_SMALL_INACTIVE, 2, 2);
    public static final IconTexture MINUS_CTRL = new IconTexture(ClientData.MINUS_SMALL_HOVERED, 2, 2);
    private final IconTexture icon;
    private final Supplier<ItemStack> supplier;
    private final DataStorage<T> data;
    private final T min;
    private final T max;
    private final T step;
    private final T stepCtrl;
    private final RangeUtils.RangeAdapter<T> adapter;
    public T cached;

    public NewRangePopupElement(int width, int height, T minValue, T maxValue, T step, T stepCtrl, RangeUtils.RangeAdapter<T> adapter, IconTexture icon, DataStorage<T> data, Supplier<ItemStack> supplier) {
        super(width, height);
        this.min = minValue;
        this.max = maxValue;
        this.step = step;
        this.stepCtrl = stepCtrl;
        this.adapter = adapter;
        this.data = data;
        this.supplier = supplier;
        this.icon = icon;
        this.cached = (Number)data.get(supplier.get());
        this.updateState();
    }

    @Override
    public T current() {
        return this.cached;
    }

    @Override
    public void set(T value) {
        this.data.sendToServer(this.supplier.get(), value);
    }

    @Override
    public T min() {
        return this.min;
    }

    @Override
    public T max() {
        return this.max;
    }

    @Override
    public RangeUtils.RangeAdapter<T> adapter() {
        return this.adapter;
    }

    @Override
    public void onClick(int button) {
        boolean changed = RangeUtils.changeValue(this, this.shiftPressed, this.ctrlPressed, ((Number)this.step).doubleValue(), ((Number)this.stepCtrl).doubleValue());
        if (changed) {
            this.updateState();
        }
    }

    @Override
    public void onMouseScroll(double delta) {
        boolean changed = RangeUtils.changeValue(this, delta < 0.0, this.ctrlPressed, ((Number)this.step).doubleValue(), ((Number)this.stepCtrl).doubleValue());
        if (changed) {
            this.updateState();
        }
    }

    @Override
    public void updateState() {
        ItemStack stack = this.supplier.get();
        this.cached = (Number)this.data.get(stack);
        this.refreshTooltip();
    }

    public void renderIcon(GuiGraphics graphics, int xPos, int yPos, boolean outOfBounds) {
        IconTexture toRender = this.icon;
        if (this.isHovered) {
            toRender = this.shiftPressed ? (outOfBounds ? MINUS_INACTIVE : (this.ctrlPressed ? MINUS_CTRL : MINUS)) : (outOfBounds ? PLUS_INACTIVE : (this.ctrlPressed ? PLUS_CTRL : PLUS));
        }
        ClientUtils.renderTexture(graphics, toRender, xPos, yPos);
    }

    @Override
    public void renderElement(GuiGraphics graphics, int xPos, int yPos) {
        boolean outOfBounds = RangeUtils.isOutOfBounds(this, this.adapter().add(this.cached, (this.ctrlPressed ? ((Number)this.stepCtrl).doubleValue() : ((Number)this.step).doubleValue()) * (double)(this.shiftPressed ? -1 : 1)));
        TextureData baseLayer = ClientData.SMALL_TOGGLE_BUTTON.get(false, this.isHovered, !outOfBounds || !this.isHovered);
        ClientUtils.renderTexture(graphics, baseLayer, xPos, yPos);
        this.renderIcon(graphics, xPos, yPos, outOfBounds);
    }

    protected String translationKey() {
        return this.data.id();
    }

    @Override
    public void refreshTooltip() {
        ArrayList<Component> components = new ArrayList<Component>();
        components.add((Component)Component.translatable((String)("tooltip.travelerscompass.settings." + this.translationKey())).withStyle(ChatFormatting.WHITE));
        MutableComponent shift = ClientUtils.coloredComponent(Component.translatable((String)"tooltip.travelerscompass.settings.modification.shift"), this.shiftPressed ? 0xAAAAAA : 0xC8C8C8);
        MutableComponent ctrl = ClientUtils.coloredComponent(Component.translatable((String)"tooltip.travelerscompass.settings.modification.ctrl"), this.ctrlPressed ? 0xAAAAAA : 0xC8C8C8);
        components.add((Component)Component.translatable((String)"tooltip.travelerscompass.settings.modification.hold_to_decrease", (Object[])new Object[]{shift}).withStyle(ChatFormatting.GRAY));
        components.add((Component)Component.translatable((String)"tooltip.travelerscompass.settings.modification.hold_to_change_faster", (Object[])new Object[]{ctrl}).withStyle(ChatFormatting.GRAY));
        if (this.shiftPressed) {
            MutableComponent desc = Component.empty().append(ClientUtils.DESC_ARROW).append((Component)Component.translatable((String)("tooltip.travelerscompass.settings." + this.translationKey() + ".desc")).withStyle(ChatFormatting.GRAY));
            components.add((Component)desc);
        }
        MutableComponent value = ClientUtils.coloredComponent(this.adapter.format(this.cached).copy(), 0xC8C8C8);
        components.add((Component)Component.translatable((String)("tooltip.travelerscompass.settings." + this.translationKey() + ".value"), (Object[])new Object[]{value}).withStyle(ChatFormatting.GRAY));
        this.setTooltip(components);
    }
}

