/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.common.search.location;

import com.nine.travelerscompass.common.search.location.ILocationObject;
import com.nine.travelerscompass.common.search.location.WithUUID;
import com.nine.travelerscompass.common.search.location.codec.LocationCodec;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;

public record EntityLocationObject(BlockPos blockPos, int slotIndex, boolean priority, String descriptionId, UUID uuid) implements ILocationObject,
WithUUID
{
    public static ResourceLocation TYPE = ResourceLocation.fromNamespaceAndPath((String)"travelerscompass", (String)"entity_location_codec");
    public static final LocationCodec<EntityLocationObject> CODEC = new LocationCodec<EntityLocationObject>(){

        @Override
        public void write(FriendlyByteBuf buf, EntityLocationObject obj) {
            this.writePosSafe(buf, obj.blockPos);
            buf.writeInt(obj.slotIndex);
            buf.writeBoolean(obj.priority);
            buf.writeUtf(obj.descriptionId);
            buf.writeUUID(obj.uuid);
        }

        @Override
        public EntityLocationObject read(FriendlyByteBuf buf) {
            BlockPos blockPos = this.readPosSafe(buf);
            int slotIndex = buf.readInt();
            boolean priority = buf.readBoolean();
            String descriptionId = buf.readUtf();
            UUID uuid = buf.readUUID();
            return new EntityLocationObject(blockPos, slotIndex, priority, descriptionId, uuid);
        }
    };

    @Override
    public ResourceLocation type() {
        return TYPE;
    }

    @Override
    public boolean isValid(ServerLevel level) {
        return level.getEntity(this.uuid) != null;
    }

    @Override
    public ILocationObject copy(BlockPos blockPos, int slotIndex, boolean priority, String descriptionId) {
        return new EntityLocationObject(blockPos, slotIndex, priority, descriptionId, this.uuid);
    }

    @Override
    public Optional<ILocationObject> update(ServerLevel level) {
        Entity entity = level.getEntity(this.uuid);
        if (entity != null && !entity.blockPosition().equals((Object)this.blockPos)) {
            return Optional.of(new EntityLocationObject(entity.blockPosition(), this.slotIndex, this.priority, this.descriptionId, this.uuid));
        }
        return Optional.of(this);
    }

    @Override
    public String toString() {
        return "Entity [" + this.descriptionId + "], " + String.valueOf(this.blockPos) + (this.priority ? " [priority]" : "");
    }
}

