/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.common.search.matcher;

import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.search.SearchOptions;
import com.nine.travelerscompass.common.search.criterion.BlockCriterion;
import com.nine.travelerscompass.common.search.criterion.EntityCriterion;
import com.nine.travelerscompass.common.search.criterion.FluidCriterion;
import com.nine.travelerscompass.common.search.criterion.ISearchCriterion;
import com.nine.travelerscompass.common.search.criterion.ItemCriterion;
import com.nine.travelerscompass.common.search.criterion.TypedCriteria;
import com.nine.travelerscompass.common.search.location.BlockLocationObject;
import com.nine.travelerscompass.common.search.location.ContainerEntityLocationObject;
import com.nine.travelerscompass.common.search.location.EntityLocationObject;
import com.nine.travelerscompass.common.search.location.ILocationObject;
import com.nine.travelerscompass.common.search.location.SpawnerLocationObject;
import com.nine.travelerscompass.common.search.matcher.BlockEntityMatcher;
import com.nine.travelerscompass.common.search.matcher.BlockMatcher;
import com.nine.travelerscompass.common.search.matcher.EntityMatcher;
import com.nine.travelerscompass.common.utils.LootUtils;
import com.nine.travelerscompass.config.TCConfig;
import com.nine.travelerscompass.mixin.accessor.BaseSpawnerAccessor;
import com.nine.travelerscompass.mixin.accessor.LiquidBlockAccessor;
import com.nine.travelerscompass.platform.Platform;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecartContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.LootTable;

public class PositionMatchers {
    public static final BlockMatcher BLOCK_MATCHER = new BlockMatcher(){

        @Override
        public ILocationObject match(TypedCriteria criteria, BlockPos pos, BlockState state) {
            Block block = state.getBlock();
            for (BlockCriterion criterion : criteria.blockCriteria) {
                if (!criterion.check(block)) continue;
                ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)block);
                return new BlockLocationObject(pos, criterion.slot(), criterion.priority(), block.getName().getString(), id);
            }
            return null;
        }

        @Override
        public boolean isAllowed(SearchOptions options) {
            return options.get(CompassProperties.BLOCKS) != false && TCConfig.ENABLE_BLOCKS_SEARCH.get() != false;
        }
    };
    public static final BlockMatcher FLUID_MATCHER = new BlockMatcher(){

        @Override
        public ILocationObject match(TypedCriteria criteria, BlockPos pos, BlockState state) {
            Block block = state.getBlock();
            if (block instanceof LiquidBlock) {
                LiquidBlock liquidBlock = (LiquidBlock)block;
                Fluid fluid = ((LiquidBlockAccessor)liquidBlock).travelerscompass$getFluidState(state).getType();
                for (FluidCriterion criterion : criteria.fluidCriteria) {
                    if (!criterion.check(fluid)) continue;
                    ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)block);
                    return new BlockLocationObject(pos.immutable(), criterion.slot(), criterion.priority(), state.getBlock().getDescriptionId(), id);
                }
            }
            return null;
        }

        @Override
        public boolean isAllowed(SearchOptions options) {
            return options.get(CompassProperties.FLUIDS) != false && TCConfig.ENABLE_FLUIDS_SEARCH.get() != false;
        }
    };
    public static final BlockEntityMatcher SPAWNER_MATCHER = new BlockEntityMatcher(){

        @Override
        public List<ILocationObject> match(TypedCriteria criteria, SearchOptions options, BlockPos pos, BlockState state, BlockEntity be) {
            CompoundTag compoundtag;
            Optional optional;
            SpawnerBlockEntity spawnerBlockEntity;
            SpawnData spawndata;
            Block block = state.getBlock();
            if (be instanceof SpawnerBlockEntity && (spawndata = ((BaseSpawnerAccessor)(spawnerBlockEntity = (SpawnerBlockEntity)be).getSpawner()).travelerscompass$nextSpawnData()) != null && (optional = EntityType.by((CompoundTag)(compoundtag = spawndata.getEntityToSpawn()))).isPresent()) {
                EntityType entityType = (EntityType)optional.get();
                for (EntityCriterion criterion : criteria.entityCriteria) {
                    if (!criterion.check(entityType)) continue;
                    ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)block);
                    return List.of(new SpawnerLocationObject(pos.immutable(), criterion.slot(), criterion.priority(), state.getBlock().getDescriptionId(), entityType.getDescriptionId(), id));
                }
            }
            return null;
        }

        @Override
        public boolean isAllowed(SearchOptions options) {
            return options.get(CompassProperties.SPAWNERS) != false && TCConfig.ENABLE_SPAWNERS_SEARCH.get() != false;
        }
    };
    public static final EntityMatcher MINECART_MATCHER = new EntityMatcher(){

        @Override
        public List<ILocationObject> match(TypedCriteria criteria, SearchOptions options, Entity entity, Level level, BlockPos pos) {
            ArrayList<ILocationObject> ret = new ArrayList<ILocationObject>();
            if (entity instanceof AbstractMinecartContainer) {
                AbstractMinecartContainer minecart = (AbstractMinecartContainer)entity;
                if (criteria.itemCriteria.isEmpty()) {
                    return List.of();
                }
                UUID uuid = minecart.getUUID();
                String descriptionId = entity.getType().getDescriptionId();
                for (ItemStack stack : minecart.getItemStacks()) {
                    Item item = stack.getItem();
                    if (!criteria.itemCriteriaMap.containsKey(item)) continue;
                    ISearchCriterion criterion = criteria.itemCriteriaMap.get(item);
                    ret.add(new ContainerEntityLocationObject(pos.immutable(), criterion.slot(), criterion.priority(), descriptionId, item.getDescriptionId(), uuid));
                }
            }
            return ret;
        }

        @Override
        public boolean isAllowed(SearchOptions options) {
            if (!options.get(CompassProperties.CONTAINERS).booleanValue() || !TCConfig.ENABLE_BLOCK_CONTAINERS_SEARCH.get().booleanValue()) {
                return false;
            }
            return options.get(CompassProperties.MINECARTS);
        }
    };
    public static final EntityMatcher EGG_MOB_MATCHER = new EntityMatcher(){

        @Override
        public List<ILocationObject> match(TypedCriteria criteria, SearchOptions options, Entity entity, Level level, BlockPos pos) {
            EntityType type = entity.getType();
            for (EntityCriterion criterion : criteria.entityCriteria) {
                if (!criterion.check(type)) continue;
                return List.of(new EntityLocationObject(entity.blockPosition(), criterion.slot(), criterion.priority(), entity.getName().getString(), entity.getUUID()));
            }
            return null;
        }

        @Override
        public boolean isAllowed(SearchOptions options) {
            return options.get(CompassProperties.MOBS) != false && TCConfig.ENABLE_MOBS_SEARCH.get() != false;
        }
    };
    public static final EntityMatcher VILLAGER_MATCHER = new EntityMatcher(){

        @Override
        public List<ILocationObject> match(TypedCriteria criteria, SearchOptions options, Entity entity, Level level, BlockPos pos) {
            ArrayList<ILocationObject> ret = new ArrayList<ILocationObject>();
            if (entity instanceof Villager) {
                Villager villager = (Villager)entity;
                MerchantOffers offers = villager.getOffers();
                boolean buys = options.get(CompassProperties.VILLAGERS_BUYS);
                boolean sells = options.get(CompassProperties.VILLAGERS_SELLS);
                UUID uuid = villager.getUUID();
                String descriptionId = entity.getType().getDescriptionId();
                for (MerchantOffer offer : offers) {
                    Item resultItem = offer.getResult().getItem();
                    Item costAItem = offer.getCostA().getItem();
                    Item costBItem = offer.getCostB().getItem();
                    for (ItemCriterion criterion : criteria.itemCriteria) {
                        if (sells && criterion.check(resultItem)) {
                            ret.add(new ContainerEntityLocationObject(pos, criterion.slot(), criterion.priority(), descriptionId, resultItem.getDescriptionId(), uuid));
                        }
                        if (!buys) continue;
                        if (criterion.check(costAItem)) {
                            ret.add(new ContainerEntityLocationObject(pos, criterion.slot(), criterion.priority(), descriptionId, costAItem.getDescriptionId(), uuid));
                        }
                        if (!criterion.check(costBItem)) continue;
                        ret.add(new ContainerEntityLocationObject(pos, criterion.slot(), criterion.priority(), descriptionId, costBItem.getDescriptionId(), uuid));
                    }
                }
                return ret;
            }
            return null;
        }

        @Override
        public boolean isAllowed(SearchOptions options) {
            return options.get(CompassProperties.VILLAGERS) != false && (options.get(CompassProperties.VILLAGERS_BUYS) != false || options.get(CompassProperties.VILLAGERS_SELLS) != false) && TCConfig.ENABLE_VILLAGERS_SEARCH.get() != false;
        }
    };
    public static final EntityMatcher INVENTORY_MATCHER = new EntityMatcher(){

        @Override
        public List<ILocationObject> match(TypedCriteria criteria, SearchOptions options, Entity entity, Level level, BlockPos pos) {
            ArrayList<ILocationObject> ret = new ArrayList<ILocationObject>();
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                HashSet<Item> invItems = new HashSet<Item>();
                boolean players = options.get(CompassProperties.INVENTORIES_PLAYERS);
                boolean mobs = options.get(CompassProperties.INVENTORIES_MOBS);
                String descriptionId = entity.getType().getDescriptionId();
                UUID uuid = entity.getUUID();
                if (uuid.equals(options.getPlayerUUID())) {
                    return null;
                }
                if (living instanceof Player) {
                    Player player = (Player)living;
                    if (players) {
                        invItems.addAll(player.getInventory().items.stream().map(ItemStack::getItem).toList());
                        invItems.addAll(player.getInventory().armor.stream().map(ItemStack::getItem).toList());
                        invItems.addAll(player.getInventory().offhand.stream().map(ItemStack::getItem).toList());
                        descriptionId = player.getDisplayName().getString();
                    }
                } else if (mobs) {
                    for (EquipmentSlot slot : EquipmentSlot.values()) {
                        invItems.add(living.getItemBySlot(slot).getItem());
                    }
                } else {
                    return null;
                }
                for (ItemCriterion criterion : criteria.itemCriteria) {
                    if (!invItems.contains(criterion.item())) continue;
                    ret.add(new ContainerEntityLocationObject(pos, criterion.slot(), criterion.priority(), descriptionId, criterion.item().getDescriptionId(), uuid));
                }
                return ret;
            }
            return null;
        }

        @Override
        public boolean isAllowed(SearchOptions options) {
            return options.get(CompassProperties.INVENTORIES) != false && (options.get(CompassProperties.INVENTORIES_MOBS) != false || options.get(CompassProperties.INVENTORIES_PLAYERS) != false);
        }
    };
    public static final EntityMatcher DROP_MATCHER = new EntityMatcher(){

        @Override
        public List<ILocationObject> match(TypedCriteria criteria, SearchOptions options, Entity entity, Level level, BlockPos pos) {
            ArrayList<ILocationObject> ret = new ArrayList<ILocationObject>();
            if (entity instanceof LivingEntity) {
                Set<Item> drops;
                LivingEntity living = (LivingEntity)entity;
                MinecraftServer server = level.getServer();
                if (server != null && (drops = LootUtils.getItemsFromLootTable((ResourceKey<LootTable>)living.getLootTable(), level)) != null) {
                    for (ItemCriterion criterion : criteria.itemCriteria) {
                        if (!drops.contains(criterion.item())) continue;
                        ret.add(new ContainerEntityLocationObject(pos, criterion.slot(), criterion.priority(), entity.getType().getDescriptionId(), criterion.item().getDescriptionId(), entity.getUUID()));
                    }
                }
                return ret;
            }
            return null;
        }

        @Override
        public boolean isAllowed(SearchOptions options) {
            return options.get(CompassProperties.DROP);
        }
    };
    public static final EntityMatcher ITEM_ENTITY_MATCHER = new EntityMatcher(){

        @Override
        public List<ILocationObject> match(TypedCriteria criteria, SearchOptions options, Entity entity, Level level, BlockPos pos) {
            ArrayList<ILocationObject> ret = new ArrayList<ILocationObject>();
            if (entity instanceof ItemEntity) {
                ItemEntity itemEntity = (ItemEntity)entity;
                if (criteria.itemCriteria.isEmpty()) {
                    return ret;
                }
                Item item = itemEntity.getItem().getItem();
                if (criteria.itemCriteriaMap.containsKey(item)) {
                    ISearchCriterion criterion = criteria.itemCriteriaMap.get(item);
                    ret.add(new EntityLocationObject(pos.immutable(), criterion.slot(), criterion.priority(), item.getDescriptionId(), itemEntity.getUUID()));
                }
                return ret;
            }
            return null;
        }

        @Override
        public boolean isAllowed(SearchOptions options) {
            return options.get(CompassProperties.ITEM_ENTITIES);
        }
    };
    public static final List<BlockMatcher> BLOCK_MATCHERS = new ArrayList<BlockMatcher>(List.of(BLOCK_MATCHER, FLUID_MATCHER));
    public static final List<BlockEntityMatcher> BLOCK_ENTITY_MATCHERS = new ArrayList<BlockEntityMatcher>(List.of(SPAWNER_MATCHER));
    public static final List<EntityMatcher> ENTITY_MATCHERS = new ArrayList<EntityMatcher>(List.of(EGG_MOB_MATCHER, INVENTORY_MATCHER, MINECART_MATCHER, VILLAGER_MATCHER, DROP_MATCHER, ITEM_ENTITY_MATCHER));

    static {
        BLOCK_MATCHERS.addAll(Platform.PLATFORM_MATCHERS.blockMatchers());
        BLOCK_ENTITY_MATCHERS.addAll(Platform.PLATFORM_MATCHERS.blockEntityMatchers());
        ENTITY_MATCHERS.addAll(Platform.PLATFORM_MATCHERS.entityMatchers());
    }
}

