/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.config;

import com.nine.travelerscompass.TCCommon;
import com.nine.travelerscompass.config.ConfigValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;

public class ConfigSyncManager {
    private static final byte BOOLEAN = 0;
    private static final byte INTEGER = 1;
    private static final byte DOUBLE = 2;
    private static final byte STRING = 3;
    private static final byte ENUM = 4;
    private static final byte LIST = 5;
    private static final byte FLOAT = 6;
    private static final Map<String, ConfigValue<?>> ALL_CONFIGS = new HashMap();
    private static final Map<String, ConfigValue<?>> SYNC_CONFIGS = new HashMap();
    public static final Map<String, Object> SYNCED_VALUES = new HashMap<String, Object>();

    public static void checkSyncable(ConfigValue<?> config) {
        ALL_CONFIGS.put(config.path(), config);
        if (config.shouldSync()) {
            SYNC_CONFIGS.put(config.path(), config);
        }
    }

    public static FriendlyByteBuf encode(FriendlyByteBuf buf) {
        buf.writeVarInt(SYNC_CONFIGS.size());
        for (Map.Entry<String, ConfigValue<?>> entry : SYNC_CONFIGS.entrySet()) {
            String path = entry.getKey();
            ConfigValue<?> config = entry.getValue();
            Object value = config.get();
            buf.writeUtf(path);
            buf.writeByte(ConfigSyncManager.getId(config.clazz()));
            ConfigSyncManager.writeTypedValue(buf, value, config.clazz());
        }
        return buf;
    }

    public static Map<String, Object> decode(FriendlyByteBuf buf) {
        int size = buf.readVarInt();
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (int i = 0; i < size; ++i) {
            String path = buf.readUtf();
            byte type = buf.readByte();
            ConfigValue<?> config = ALL_CONFIGS.get(path);
            if (config != null) {
                Object value = ConfigSyncManager.readTypedValue(buf, config.clazz(), type);
                if (value == null) continue;
                ret.put(path, value);
                continue;
            }
            TCCommon.LOGGER.warn("Could not sync config value: {}", (Object)path);
        }
        return ret;
    }

    private static <T> void writeTypedValue(FriendlyByteBuf buf, Object value, Class<T> clazz) {
        if (clazz == Boolean.class) {
            buf.writeBoolean(((Boolean)value).booleanValue());
        } else if (clazz == Integer.class) {
            buf.writeInt(((Integer)value).intValue());
        } else if (clazz == Double.class) {
            buf.writeDouble(((Double)value).doubleValue());
        } else if (clazz == String.class) {
            buf.writeUtf((String)value);
        } else if (clazz == Float.class) {
            buf.writeFloat(((Float)value).floatValue());
        } else if (Enum.class.isAssignableFrom(clazz)) {
            buf.writeEnum((Enum)value);
        } else if (List.class.isAssignableFrom(clazz)) {
            List list = (List)value;
            buf.writeVarInt(list.size());
            if (list.isEmpty()) {
                return;
            }
            Class<?> contentClass = list.get(0).getClass();
            buf.writeByte(ConfigSyncManager.getId(contentClass));
            if (Enum.class.isAssignableFrom(contentClass)) {
                buf.writeUtf(contentClass.getName());
            }
            for (Object el : list) {
                ConfigSyncManager.writeTypedValue(buf, el, contentClass);
            }
        } else {
            throw new IllegalArgumentException("Unsupported config type: " + String.valueOf(clazz));
        }
    }

    private static Object readTypedValue(FriendlyByteBuf buf, Class<?> clazz, byte type) {
        return switch (type) {
            case 0 -> {
                Boolean var3_3 = buf.readBoolean();
                yield var3_3;
            }
            case 1 -> {
                Integer var3_4 = buf.readInt();
                yield var3_4;
            }
            case 2 -> {
                Double var3_5 = buf.readDouble();
                yield var3_5;
            }
            case 3 -> {
                String var3_6 = buf.readUtf();
                yield var3_6;
            }
            case 6 -> {
                Float var3_7 = Float.valueOf(buf.readFloat());
                yield var3_7;
            }
            case 4 -> {
                Enum var3_8 = buf.readEnum(clazz);
                yield var3_8;
            }
            case 5 -> {
                ArrayList<Object> var3_9;
                int size = buf.readVarInt();
                ArrayList<Object> ret = new ArrayList<Object>();
                if (size > 0) {
                    Class v1;
                    byte contentType = buf.readByte();
                    switch (contentType) {
                        case 0: {
                            Class var8_13;
                            v1 = var8_13 = Boolean.class;
                            break;
                        }
                        case 1: {
                            Class var8_13;
                            v1 = var8_13 = Integer.class;
                            break;
                        }
                        case 2: {
                            Class var8_13;
                            v1 = var8_13 = Double.class;
                            break;
                        }
                        case 3: {
                            Class var8_13;
                            v1 = var8_13 = String.class;
                            break;
                        }
                        case 6: {
                            Class var8_13;
                            v1 = var8_13 = Float.class;
                            break;
                        }
                        case 4: {
                            Class var8_13;
                            String classPath = buf.readUtf();
                            try {
                                v1 = var8_13 = Class.forName(classPath);
                                break;
                            }
                            catch (ClassNotFoundException e) {
                                throw new RuntimeException("Unknown enum class: " + classPath);
                            }
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown element type in list: " + contentType);
                        }
                    }
                    Class contentClass = v1;
                    for (int i = 0; i < size; ++i) {
                        Object val = ConfigSyncManager.readTypedValue(buf, contentClass, contentType);
                        ret.add(val);
                    }
                }
                yield var3_9 = ret;
            }
            default -> throw new IllegalArgumentException("Unknown type ID: " + type);
        };
    }

    private static byte getId(Class<?> clazz) {
        if (clazz == Boolean.class) {
            return 0;
        }
        if (clazz == Double.class) {
            return 2;
        }
        if (clazz == Integer.class) {
            return 1;
        }
        if (clazz == String.class) {
            return 3;
        }
        if (clazz == Float.class) {
            return 6;
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            return 4;
        }
        if (List.class.isAssignableFrom(clazz)) {
            return 5;
        }
        throw new RuntimeException("Unsupported config type: " + String.valueOf(clazz));
    }
}

