/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.network.packet.c2s;

import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.data.DataStorage;
import com.nine.travelerscompass.common.item.TravelersCompassItem;
import com.nine.travelerscompass.network.packet.c2s.C2SPacket;
import java.util.UUID;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public record CompassDataPacket<T>(UUID compassUUID, DataStorage<T> dataStorage, T value) implements C2SPacket
{
    public static final CustomPacketPayload.Type<CompassDataPacket> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"travelerscompass", (String)"compass_data_packet"));
    public static final StreamCodec<RegistryFriendlyByteBuf, CompassDataPacket> PACKET_CODEC = StreamCodec.ofMember(CompassDataPacket::encode, CompassDataPacket::decode);

    public void encode(RegistryFriendlyByteBuf buf) {
        buf.writeByte(this.dataStorage.networkId());
        if (CompassProperties.CLIENT_EDITABLE.containsKey(this.dataStorage.networkId())) {
            buf.writeUUID(this.compassUUID);
            this.dataStorage.dataComponent().streamCodec().encode((Object)buf, this.value);
        }
    }

    public static <T> CompassDataPacket<?> decode(RegistryFriendlyByteBuf buf) {
        byte networkId = buf.readByte();
        DataStorage dataStorage = CompassProperties.getById(networkId);
        UUID uuid = null;
        Object value = null;
        if (CompassProperties.CLIENT_EDITABLE.containsKey(dataStorage.networkId())) {
            uuid = buf.readUUID();
            value = dataStorage.dataComponent().streamCodec().decode((Object)buf);
        }
        return new CompassDataPacket<Object>(uuid, dataStorage, value);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    @Override
    public void handle(ServerPlayer player) {
        ItemStack stack;
        if (CompassProperties.CLIENT_EDITABLE.containsKey(this.dataStorage.networkId()) && (stack = player.getMainHandItem()).getItem() instanceof TravelersCompassItem) {
            this.dataStorage.set(stack, this.value);
        }
    }
}

