/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.network.packet.c2s;

import com.nine.travelerscompass.common.container.menu.CompassMenu;
import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.item.TravelersCompassItem;
import com.nine.travelerscompass.common.search.SearchManager;
import com.nine.travelerscompass.common.utils.SearchState;
import com.nine.travelerscompass.network.packet.c2s.C2SPacket;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public record PausePacket(UUID uuid) implements C2SPacket
{
    public static final CustomPacketPayload.Type<PausePacket> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"travelerscompass", (String)"pause_packet"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PausePacket> PACKET_CODEC = StreamCodec.ofMember(PausePacket::encode, PausePacket::decode);

    public void encode(RegistryFriendlyByteBuf buf) {
        buf.writeUUID(this.uuid);
    }

    public static PausePacket decode(RegistryFriendlyByteBuf buf) {
        return new PausePacket(buf.readUUID());
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    @Override
    public void handle(ServerPlayer player) {
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof CompassMenu) {
            CompassMenu menu = (CompassMenu)abstractContainerMenu;
            ItemStack stack = player.getMainHandItem();
            if (stack.getItem() instanceof TravelersCompassItem && Objects.equals(CompassProperties.COMPASS_UUID.get(stack), this.uuid) && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = player;
                SearchManager.stopScan(this.uuid);
                SearchManager.removeWatcher(this.uuid, serverPlayer);
                CompassProperties.SEARCH_STATE.set(stack, SearchState.IDLE);
            }
        }
    }
}

