/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.network.packet.s2c;

import com.nine.travelerscompass.client.ClientData;
import com.nine.travelerscompass.common.search.location.ILocationObject;
import com.nine.travelerscompass.common.search.location.codec.LocationCodecs;
import com.nine.travelerscompass.network.packet.s2c.S2CPacket;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public record HudDataPacket(ILocationObject object, UUID uuid) implements S2CPacket
{
    public static final CustomPacketPayload.Type<HudDataPacket> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"travelerscompass", (String)"hud_data_packet"));
    public static final StreamCodec<RegistryFriendlyByteBuf, HudDataPacket> CODEC = StreamCodec.ofMember(HudDataPacket::encode, HudDataPacket::decode);

    public void encode(RegistryFriendlyByteBuf buf) {
        boolean valid = this.object != null;
        buf.writeBoolean(valid);
        if (valid) {
            LocationCodecs.encode((FriendlyByteBuf)buf, this.object);
        }
        buf.writeUUID(this.uuid);
    }

    public static HudDataPacket decode(RegistryFriendlyByteBuf buf) {
        boolean valid = buf.readBoolean();
        ILocationObject object = valid ? LocationCodecs.read((FriendlyByteBuf)buf) : null;
        UUID uuid = buf.readUUID();
        return new HudDataPacket(object, uuid);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    @Override
    public void handle() {
        if (ClientData.HUD_DATA_CACHE.containsKey(this.uuid)) {
            ClientData.HUD_DATA_CACHE.get(this.uuid).setLocationObject(this.object);
        }
    }
}

