/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.network.packet.s2c;

import com.nine.travelerscompass.client.ClientData;
import com.nine.travelerscompass.client.utils.SearchProgress;
import com.nine.travelerscompass.network.packet.s2c.S2CPacket;
import java.util.UUID;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public record SearchProgressSyncPacket(SearchProgress searchProgress, UUID uuid) implements S2CPacket
{
    public static final CustomPacketPayload.Type<SearchProgressSyncPacket> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"travelerscompass", (String)"search_progress_packet"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SearchProgressSyncPacket> CODEC = StreamCodec.ofMember(SearchProgressSyncPacket::encode, SearchProgressSyncPacket::decode);

    public void encode(RegistryFriendlyByteBuf buf) {
        buf.writeVarInt(this.searchProgress.progress);
        buf.writeVarInt(this.searchProgress.total);
        buf.writeUUID(this.uuid);
    }

    public static SearchProgressSyncPacket decode(RegistryFriendlyByteBuf buf) {
        SearchProgress searchProgress = new SearchProgress(buf.readVarInt(), buf.readVarInt());
        return new SearchProgressSyncPacket(searchProgress, buf.readUUID());
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    @Override
    public void handle() {
        if (this.searchProgress.progress < 0) {
            ClientData.PROGRESS_DATA_CACHE.remove(this.uuid);
        } else {
            ClientData.PROGRESS_DATA_CACHE.put(this.uuid, this.searchProgress);
        }
    }
}

