/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.treetap.common.block.entity;

import cy.jdkdigital.treetap.TreeTap;
import cy.jdkdigital.treetap.common.block.TapBlock;
import cy.jdkdigital.treetap.common.block.entity.SapCollectorBlockEntity;
import cy.jdkdigital.treetap.common.recipe.TapExtractRecipe;
import cy.jdkdigital.treetap.compat.CompatHandler;
import cy.jdkdigital.treetap.util.ColorUtil;
import java.util.Optional;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;

public class TapBlockEntity
extends BlockEntity {
    private int counter = 0;
    public RecipeHolder<TapExtractRecipe> currentRecipe;
    public boolean hasSearchedForRecipe = false;

    public TapBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TreeTap.TAP_BLOCK_ENTITY.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, TapBlockEntity blockEntity) {
        BlockEntity blockEntity2 = level.getBlockEntity(pos.below());
        if (blockEntity2 instanceof SapCollectorBlockEntity) {
            SapCollectorBlockEntity sapCollector = (SapCollectorBlockEntity)blockEntity2;
            if (blockEntity.currentRecipe == null && !blockEntity.hasSearchedForRecipe) {
                BlockState log = level.getBlockState(pos.relative(((Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING)).getOpposite()));
                blockEntity.currentRecipe = TreeTap.getRecipe(level, log);
                sapCollector.setCurrentRecipe(blockEntity.currentRecipe);
                if (blockEntity.currentRecipe != null) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BlockStateProperties.ATTACHED, (Comparable)Boolean.valueOf(true)));
                    if (!((TapExtractRecipe)blockEntity.currentRecipe.value()).particleColor.isEmpty()) {
                        TapBlock.color.put(pos, ColorUtil.getCacheColor(ColorUtil.getCacheColor(((TapExtractRecipe)blockEntity.currentRecipe.value()).particleColor)));
                    } else if (!((TapExtractRecipe)blockEntity.currentRecipe.value()).fluidColor.isEmpty()) {
                        TapBlock.color.put(pos, ColorUtil.getCacheColor(ColorUtil.getCacheColor(((TapExtractRecipe)blockEntity.currentRecipe.value()).fluidColor)));
                    } else {
                        IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)((TapExtractRecipe)blockEntity.currentRecipe.value()).displayFluid.getFluid());
                        int fluidTintColour = renderProperties.getTintColor(((TapExtractRecipe)blockEntity.currentRecipe.value()).displayFluid);
                        TapBlock.color.put(pos, ColorUtil.getCacheColor(fluidTintColour));
                    }
                } else {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BlockStateProperties.ATTACHED, (Comparable)Boolean.valueOf(false)));
                }
                blockEntity.hasSearchedForRecipe = true;
            } else if (blockEntity.currentRecipe != null) {
                if (CompatHandler.canProcess(blockEntity.currentRecipe)) {
                    int tickRate = TreeTap.recipeTickrate(blockEntity.currentRecipe);
                    if (++blockEntity.counter % tickRate == 0) {
                        if (sapCollector.progress > ((TapExtractRecipe)blockEntity.currentRecipe.value()).processingTime) {
                            sapCollector.progress = ((TapExtractRecipe)blockEntity.currentRecipe.value()).processingTime;
                        } else {
                            float mod = 1.0f;
                            Block block = state.getBlock();
                            if (block instanceof TapBlock) {
                                TapBlock tapBlock = (TapBlock)block;
                                mod = tapBlock.getModifier(level, pos);
                            }
                            sapCollector.addProgress((int)((float)tickRate * mod));
                            level.sendBlockUpdated(pos.below(), sapCollector.getBlockState(), sapCollector.getBlockState(), 2);
                        }
                    }
                    if (!((Boolean)state.getValue((Property)BlockStateProperties.ATTACHED)).booleanValue()) {
                        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BlockStateProperties.ATTACHED, (Comparable)Boolean.valueOf(true)));
                    }
                } else if (((Boolean)state.getValue((Property)BlockStateProperties.ATTACHED)).booleanValue()) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BlockStateProperties.ATTACHED, (Comparable)Boolean.valueOf(false)));
                }
            }
        }
    }

    public void reset() {
        this.currentRecipe = null;
        this.hasSearchedForRecipe = false;
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.loadPacketNBT(pTag, pRegistries);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(tag, pRegistries);
        this.savePacketNBT(tag, pRegistries);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        return this.saveWithId(pRegistries);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, pkt, lookupProvider);
        this.loadPacketNBT(pkt.getTag(), lookupProvider);
        if (this.level instanceof ClientLevel) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 0);
        }
    }

    public void loadPacketNBT(CompoundTag tag, HolderLookup.Provider pRegistries) {
        if (tag.contains("recipe") && this.level != null) {
            Optional recipe = this.level.getRecipeManager().byKey(ResourceLocation.parse((String)tag.getString("recipe")));
            recipe.ifPresent(value -> {
                this.currentRecipe = value;
            });
        }
    }

    public void savePacketNBT(CompoundTag tag, HolderLookup.Provider pRegistries) {
        if (this.currentRecipe != null) {
            tag.putString("recipe", this.currentRecipe.id().toString());
        }
    }
}

