/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.client.level.sound;

import com.blackgear.vanillabackport.client.registries.ModSoundEvents;
import com.blackgear.vanillabackport.core.data.tags.ModBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;

public class AmbientDesertBlockSoundsPlayer {
    private static final int IDLE_SOUND_CHANCE = 2100;
    private static final int DRY_GRASS_SOUND_CHANCE = 200;
    private static final int DEAD_BUSH_SOUND_CHANCE = 130;
    private static final int DEAD_BUSH_SOUND_BADLANDS_DECREASED_CHANCE = 3;
    private static final int SURROUNDING_BLOCKS_PLAY_SOUND_THRESHOLD = 3;
    private static final int SURROUNDING_BLOCKS_DISTANCE_HORIZONTAL_CHECK = 8;
    private static final int SURROUNDING_BLOCKS_DISTANCE_VERTICAL_CHECK = 5;
    private static final int HORIZONTAL_DIRECTIONS = 4;

    public static void playAmbientSandSounds(Level level, BlockPos pos, RandomSource random) {
        if (!level.getBlockState(pos).is(BlockTags.SAND)) {
            return;
        }
        if (level.getBlockState(pos.above()).is(Blocks.AIR) && random.nextInt(2100) == 0 && AmbientDesertBlockSoundsPlayer.shouldPlayAmbientSandSound(level, pos)) {
            level.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), ModSoundEvents.SAND_IDLE.get(), SoundSource.AMBIENT, 1.0f, 1.0f, false);
        }
    }

    public static void playAmbientDryGrassSounds(Level level, BlockPos pos, RandomSource random) {
        if (random.nextInt(200) == 0 && AmbientDesertBlockSoundsPlayer.shouldPlayDesertDryVegetationBlockSounds(level, pos.below())) {
            level.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), ModSoundEvents.DRY_GRASS.get(), SoundSource.AMBIENT, 1.0f, 1.0f, false);
        }
    }

    public static void playAmbientDeadBushSounds(Level level, BlockPos pos, RandomSource random) {
        if (random.nextInt(130) == 0) {
            BlockState state = level.getBlockState(pos.below());
            if ((state.is(Blocks.RED_SAND) || state.is(BlockTags.TERRACOTTA)) && random.nextInt(3) != 0) {
                return;
            }
            if (AmbientDesertBlockSoundsPlayer.shouldPlayDesertDryVegetationBlockSounds(level, pos.below())) {
                level.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), ModSoundEvents.DEAD_BUSH_IDLE.get(), SoundSource.AMBIENT, 1.0f, 1.0f, false);
            }
        }
    }

    public static boolean shouldPlayDesertDryVegetationBlockSounds(Level level, BlockPos pos) {
        return level.getBlockState(pos).is(ModBlockTags.TRIGGERS_AMBIENT_DESERT_DRY_VEGETATION_BLOCK_SOUNDS) && level.getBlockState(pos.below()).is(ModBlockTags.TRIGGERS_AMBIENT_DESERT_DRY_VEGETATION_BLOCK_SOUNDS);
    }

    private static boolean shouldPlayAmbientSandSound(Level level, BlockPos pos) {
        int found = 0;
        int checked = 0;
        BlockPos.MutableBlockPos mutable = pos.mutable();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            int remaining;
            int possible;
            mutable.set((Vec3i)pos).move(direction, 8);
            if (AmbientDesertBlockSoundsPlayer.columnContainsTriggeringBlock(level, mutable) && found++ >= 3) {
                return true;
            }
            if ((possible = (remaining = 4 - ++checked) + found) >= 3) continue;
            return false;
        }
        return false;
    }

    private static boolean columnContainsTriggeringBlock(Level level, BlockPos.MutableBlockPos mutable) {
        int surfaceY = level.getHeight(Heightmap.Types.WORLD_SURFACE, mutable.getX(), mutable.getZ()) - 1;
        if (Math.abs(surfaceY - mutable.getY()) > 5) {
            mutable.move(Direction.UP, 6);
            BlockState state = level.getBlockState((BlockPos)mutable);
            mutable.move(Direction.DOWN);
            for (int i = 0; i < 10; ++i) {
                BlockState localState = level.getBlockState((BlockPos)mutable);
                if (state.isAir() && AmbientDesertBlockSoundsPlayer.canTriggerAmbientDesertSandSounds(localState)) {
                    return true;
                }
                state = localState;
                mutable.move(Direction.DOWN);
            }
            return false;
        }
        boolean hasAirAbove = level.getBlockState((BlockPos)mutable.setY(surfaceY + 1)).isAir();
        return hasAirAbove && AmbientDesertBlockSoundsPlayer.canTriggerAmbientDesertSandSounds(level.getBlockState((BlockPos)mutable.setY(surfaceY)));
    }

    private static boolean canTriggerAmbientDesertSandSounds(BlockState state) {
        return state.is(ModBlockTags.TRIGGERS_AMBIENT_DESERT_SAND_BLOCK_SOUNDS);
    }
}

