/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.level.blocks;

import com.blackgear.vanillabackport.client.level.particles.particleoptions.TrailParticleOption;
import com.blackgear.vanillabackport.client.registries.ModSoundEvents;
import com.blackgear.vanillabackport.common.level.blocks.CreakingHeartBlock;
import com.blackgear.vanillabackport.common.registries.ModBlocks;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class EyeblossomBlock
extends FlowerBlock {
    public static final MapCodec<EyeblossomBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.fieldOf("open").forGetter(block -> block.type.open), (App)EyeblossomBlock.propertiesCodec()).apply((Applicative)instance, EyeblossomBlock::new));
    private final Type type;

    public MapCodec<? extends EyeblossomBlock> codec() {
        return CODEC;
    }

    public EyeblossomBlock(Type type, BlockBehaviour.Properties properties) {
        super(type.effect, (float)type.effectDuration, properties);
        this.type = type;
    }

    public EyeblossomBlock(boolean open, BlockBehaviour.Properties properties) {
        super(Type.fromBoolean((boolean)open).effect, (float)Type.fromBoolean((boolean)open).effectDuration, properties);
        this.type = Type.fromBoolean(open);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        BlockState floorState;
        if (this.type.emitSounds() && random.nextInt(700) == 0 && (floorState = level.getBlockState(pos.below())).is(ModBlocks.PALE_MOSS_BLOCK.get())) {
            level.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), ModSoundEvents.EYEBLOSSOM_IDLE.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (this.tryChangingState(state, level, pos, random)) {
            level.playSound(null, pos, this.type.transform().longSwitchSound, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        super.randomTick(state, level, pos, random);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (this.tryChangingState(state, level, pos, random)) {
            level.playSound(null, pos, this.type.transform().shortSwitchSound, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        super.tick(state, level, pos, random);
    }

    private boolean tryChangingState(BlockState state, ServerLevel level, BlockPos origin, RandomSource random) {
        if (!level.dimensionType().natural()) {
            return false;
        }
        if (CreakingHeartBlock.isNaturalNight((Level)level) == this.type.open) {
            return false;
        }
        Type type = this.type.transform();
        level.setBlock(origin, type.state(), 3);
        level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, origin, GameEvent.Context.of((BlockState)state));
        type.spawnTransformParticle(level, origin, random);
        BlockPos.betweenClosed((BlockPos)origin.offset(-3, -2, -3), (BlockPos)origin.offset(3, 2, 3)).forEach(pos -> {
            BlockState closeState = level.getBlockState(pos);
            if (closeState == state) {
                double distance = Math.sqrt(origin.distSqr((Vec3i)pos));
                int ticks = random.nextIntBetweenInclusive((int)(distance * 5.0), (int)(distance * 10.0));
                level.scheduleTick(pos, state.getBlock(), ticks);
            }
        });
        return true;
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        Bee bee;
        if (!level.isClientSide() && level.getDifficulty() != Difficulty.PEACEFUL && entity instanceof Bee && !(bee = (Bee)entity).hasEffect(MobEffects.POISON)) {
            bee.addEffect(new MobEffectInstance(MobEffects.POISON, 25));
        }
    }

    public static enum Type {
        OPEN(true, (Holder<MobEffect>)MobEffects.BLINDNESS, 11, ModSoundEvents.EYEBLOSSOM_OPEN_LONG.get(), ModSoundEvents.EYEBLOSSOM_OPEN.get(), 16545810),
        CLOSED(false, (Holder<MobEffect>)MobEffects.CONFUSION, 7, ModSoundEvents.EYEBLOSSOM_CLOSE_LONG.get(), ModSoundEvents.EYEBLOSSOM_CLOSE.get(), 0x5F5F5F);

        final boolean open;
        final Holder<MobEffect> effect;
        final int effectDuration;
        final SoundEvent longSwitchSound;
        final SoundEvent shortSwitchSound;
        final int particleColor;

        private Type(boolean open, Holder<MobEffect> effect, int effectDuration, SoundEvent longSwitchSound, SoundEvent shortSwitchSound, int particleColor) {
            this.open = open;
            this.effect = effect;
            this.effectDuration = effectDuration;
            this.longSwitchSound = longSwitchSound;
            this.shortSwitchSound = shortSwitchSound;
            this.particleColor = particleColor;
        }

        public Block block() {
            return this.open ? ModBlocks.OPEN_EYEBLOSSOM.get() : ModBlocks.CLOSED_EYEBLOSSOM.get();
        }

        public BlockState state() {
            return this.block().defaultBlockState();
        }

        public Type transform() {
            return Type.fromBoolean(!this.open);
        }

        public boolean emitSounds() {
            return this.open;
        }

        public static Type fromBoolean(boolean open) {
            return open ? OPEN : CLOSED;
        }

        public void spawnTransformParticle(ServerLevel level, BlockPos pos, RandomSource random) {
            Vec3 center = pos.getCenter();
            double scale = 0.5 + random.nextDouble();
            Vec3 offset = new Vec3(random.nextDouble() - 0.5, random.nextDouble() + 1.0, random.nextDouble() - 0.5);
            Vec3 target = center.add(offset.scale(scale));
            TrailParticleOption particle = new TrailParticleOption(target, this.particleColor, (int)(20.0 * scale));
            level.sendParticles((ParticleOptions)particle, center.x, center.y, center.z, 1, 0.0, 0.0, 0.0, 0.0);
        }

        public SoundEvent longSwitchSound() {
            return this.longSwitchSound;
        }
    }
}

