/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.level.boat;

import com.blackgear.vanillabackport.common.registries.ModBlocks;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;

public interface PaleOakBoatBehavior {
    default public void fall(Boat boat, double y, boolean onGround) {
        boat.lastYd = boat.getDeltaMovement().y;
        if (!boat.isPassenger()) {
            if (onGround) {
                if (boat.fallDistance > 3.0f) {
                    if (boat.status != Boat.Status.ON_LAND) {
                        boat.resetFallDistance();
                        return;
                    }
                    boat.causeFallDamage(boat.fallDistance, 1.0f, boat.damageSources().fall());
                    if (!boat.level().isClientSide() && !boat.isRemoved()) {
                        boat.kill();
                        if (boat.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                            int i;
                            for (i = 0; i < 3; ++i) {
                                boat.spawnAtLocation((ItemLike)ModBlocks.PALE_OAK_PLANKS.get());
                            }
                            for (i = 0; i < 3; ++i) {
                                boat.spawnAtLocation((ItemLike)Items.STICK);
                            }
                        }
                    }
                }
                boat.resetFallDistance();
            } else if (!boat.level().getFluidState(boat.blockPosition().below()).is(FluidTags.WATER) && y < 0.0) {
                boat.fallDistance -= (float)y;
            }
        }
    }
}

