/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.core.mixin.common.entities;

import com.blackgear.vanillabackport.common.level.entities.happyghast.HappyGhast;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundMoveEntityPacket;
import net.minecraft.network.protocol.game.ClientboundRotateHeadPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket;
import net.minecraft.network.protocol.game.VecDeltaCodec;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerEntity.class})
public abstract class ServerEntityMixin {
    @Shadow
    private int tickCount;
    @Shadow
    private int lastSentXRot;
    @Shadow
    private int lastSentYRot;
    @Shadow
    private int teleportDelay;
    @Shadow
    private boolean wasRiding;
    @Shadow
    private boolean wasOnGround;
    @Shadow
    @Final
    private Entity entity;
    @Shadow
    private int lastSentYHeadRot;
    @Shadow
    private Vec3 lastSentMovement;
    @Shadow
    @Final
    private int updateInterval;
    @Shadow
    @Final
    private boolean trackDelta;
    @Shadow
    private List<Entity> lastPassengers;
    @Shadow
    @Final
    private VecDeltaCodec positionCodec;
    @Shadow
    @Final
    private Consumer<Packet<?>> broadcast;

    @Shadow
    protected abstract void sendDirtyEntityData();

    @Shadow
    protected abstract void broadcastAndSend(Packet<?> var1);

    @Shadow
    private static Stream<Entity> removedPassengers(List<Entity> initialPassengers, List<Entity> currentPassengers) {
        throw new AssertionError();
    }

    @Inject(method={"sendChanges()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSendChanges(CallbackInfo ci) {
        Entity entity2 = this.entity;
        if (entity2 instanceof HappyGhast) {
            HappyGhast ghast = (HappyGhast)entity2;
            List passengers = this.entity.getPassengers();
            if (!passengers.equals(this.lastPassengers)) {
                this.broadcast.accept((Packet<?>)new ClientboundSetPassengersPacket(this.entity));
                ServerEntityMixin.removedPassengers(passengers, this.lastPassengers).forEach(entity -> {
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)entity;
                        player.connection.teleport(player.getX(), player.getY(), player.getZ(), player.getYRot(), player.getXRot());
                    }
                });
                this.lastPassengers = passengers;
            }
            if (this.tickCount % this.updateInterval == 0 || this.entity.hasImpulse || this.entity.getEntityData().isDirty()) {
                int headYaw;
                if (!this.entity.isPassenger()) {
                    Vec3 movement;
                    double distance;
                    ++this.teleportDelay;
                    int yRot = Mth.floor((float)(this.entity.getYRot() * 256.0f / 360.0f));
                    int xRot = Mth.floor((float)(this.entity.getXRot() * 256.0f / 360.0f));
                    Vec3 position = this.entity.trackingPosition();
                    boolean positionChanged = this.positionCodec.delta(position).lengthSqr() >= 7.62939453125E-6;
                    boolean shouldUpdatePosition = positionChanged || this.tickCount % 60 == 0;
                    boolean shouldUpdateRotation = Math.abs(yRot - this.lastSentYRot) >= 1 || Math.abs(xRot - this.lastSentXRot) >= 1;
                    ClientboundTeleportEntityPacket packet = null;
                    boolean positionUpdated = false;
                    boolean rotationUpdated = false;
                    if (this.tickCount > 0 || this.entity instanceof AbstractArrow) {
                        boolean isOutOfRange;
                        long x = this.positionCodec.encodeX(position);
                        long y = this.positionCodec.encodeY(position);
                        long z = this.positionCodec.encodeZ(position);
                        boolean bl = isOutOfRange = x < -32768L || x > 32767L || y < -32768L || y > 32767L || z < -32768L || z > 32767L;
                        if (ghast.getRequiresPrecisePosition() || isOutOfRange || this.teleportDelay > 400 || this.wasRiding || this.wasOnGround != this.entity.onGround()) {
                            this.wasOnGround = this.entity.onGround();
                            this.teleportDelay = 0;
                            packet = new ClientboundTeleportEntityPacket(this.entity);
                            positionUpdated = true;
                            rotationUpdated = true;
                        } else if (!(shouldUpdatePosition && shouldUpdateRotation || this.entity instanceof AbstractArrow)) {
                            if (shouldUpdatePosition) {
                                packet = new ClientboundMoveEntityPacket.Pos(this.entity.getId(), (short)x, (short)y, (short)z, this.entity.onGround());
                                positionUpdated = true;
                            } else if (shouldUpdateRotation) {
                                packet = new ClientboundMoveEntityPacket.Rot(this.entity.getId(), (byte)yRot, (byte)xRot, this.entity.onGround());
                                rotationUpdated = true;
                            }
                        } else {
                            packet = new ClientboundMoveEntityPacket.PosRot(this.entity.getId(), (short)x, (short)y, (short)z, (byte)yRot, (byte)xRot, this.entity.onGround());
                            positionUpdated = true;
                            rotationUpdated = true;
                            ghast.setRequiresPrecisePosition(false);
                        }
                    }
                    if ((this.trackDelta || this.entity.hasImpulse || this.entity instanceof LivingEntity && ((LivingEntity)this.entity).isFallFlying()) && this.tickCount > 0 && ((distance = (movement = this.entity.getDeltaMovement()).distanceToSqr(this.lastSentMovement)) > 1.0E-7 || distance > 0.0 && movement.lengthSqr() == 0.0)) {
                        this.lastSentMovement = movement;
                        this.broadcast.accept((Packet<?>)new ClientboundSetEntityMotionPacket(this.entity.getId(), this.lastSentMovement));
                    }
                    if (packet != null) {
                        this.broadcast.accept((Packet<?>)packet);
                    }
                    this.sendDirtyEntityData();
                    if (positionUpdated) {
                        this.positionCodec.setBase(position);
                    }
                    if (rotationUpdated) {
                        this.lastSentYRot = yRot;
                        this.lastSentXRot = xRot;
                    }
                    this.wasRiding = false;
                }
                if (Math.abs((headYaw = Mth.floor((float)(this.entity.getYHeadRot() * 256.0f / 360.0f))) - this.lastSentYHeadRot) >= 1) {
                    this.broadcast.accept((Packet<?>)new ClientboundRotateHeadPacket(this.entity, (byte)headYaw));
                    this.lastSentYHeadRot = headYaw;
                }
                this.entity.hasImpulse = false;
            }
            ++this.tickCount;
            if (this.entity.hurtMarked) {
                this.entity.hurtMarked = false;
                this.broadcastAndSend((Packet<?>)new ClientboundSetEntityMotionPacket(this.entity));
            }
            ci.cancel();
        }
    }
}

