/*
 * Decompiled with CFR 0.152.
 */
package com.unrealdinnerbone.weathergate.events;

import com.unrealdinnerbone.weathergate.WeatherGateRegistry;
import com.unrealdinnerbone.weathergate.client.WeatherGateClient;
import com.unrealdinnerbone.weathergate.level.attachments.SunInABlockAttachment;
import com.unrealdinnerbone.weathergate.level.attachments.TerrainControllerAttachment;
import com.unrealdinnerbone.weathergate.network.packets.s2c.SyncSunInABoxPosPacket;
import com.unrealdinnerbone.weathergate.network.packets.s2c.colorsync.SyncColorsPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class ServerEvents {
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player;
        if (!event.getEntity().level().isClientSide() && (player = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Level level = serverPlayer.level();
            TerrainControllerAttachment data = (TerrainControllerAttachment)level.getData((AttachmentType)WeatherGateRegistry.TERIANN_CONTROLLER_ATTACHMENT.get());
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncColorsPacket((ResourceKey<Level>)level.dimension(), data.data()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            SunInABlockAttachment sunInABlockAttachment = (SunInABlockAttachment)level.getData((AttachmentType)WeatherGateRegistry.SUN_IN_A_BOX_ATTACHMENT.get());
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncSunInABoxPosPacket((ResourceKey<Level>)level.dimension(), sunInABlockAttachment.blockPosList()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player;
        if (!event.getEntity().level().isClientSide() && (player = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ResourceKey level = event.getTo();
            ServerLevel level1 = serverPlayer.getServer().getLevel(level);
            if (level1 != null) {
                TerrainControllerAttachment data = (TerrainControllerAttachment)level1.getData((AttachmentType)WeatherGateRegistry.TERIANN_CONTROLLER_ATTACHMENT.get());
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncColorsPacket((ResourceKey<Level>)level, data.data()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                SunInABlockAttachment sunInABlockAttachment = (SunInABlockAttachment)level1.getData((AttachmentType)WeatherGateRegistry.SUN_IN_A_BOX_ATTACHMENT.get());
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncSunInABoxPosPacket((ResourceKey<Level>)level1.dimension(), sunInABlockAttachment.blockPosList()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getEntity().level().isClientSide()) {
            WeatherGateClient.BLOCK_COLORS.clear();
            WeatherGateClient.SUN_IN_BOX_LOCATIONS.clear();
        }
    }
}

