/*
 * Decompiled with CFR 0.152.
 */
package com.unrealdinnerbone.weathergate.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.unrealdinnerbone.weathergate.client.WeatherGateClient;
import com.unrealdinnerbone.weathergate.util.RangeUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={ClientLevel.class})
public class ClientLevelMixin {
    @Shadow
    @Final
    private Minecraft minecraft;

    @ModifyExpressionValue(method={"getSkyColor(Lnet/minecraft/world/phys/Vec3;F)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;getTimeOfDay(F)F")})
    public float modifySkyColor(float original) {
        ClientLevel level = (ClientLevel)this;
        BlockPos position = this.minecraft.gameRenderer.getMainCamera().getBlockPosition();
        if (WeatherGateClient.SUN_IN_BOX_LOCATIONS.containsKey(level.dimension())) {
            for (BlockPos blockPos : WeatherGateClient.SUN_IN_BOX_LOCATIONS.get(level.dimension())) {
                if (!RangeUtils.isWithinRange((Vec3i)blockPos, (Vec3i)position, 64)) continue;
                return 0.0f;
            }
        }
        return original;
    }

    @ModifyExpressionValue(method={"getSkyDarken(F)F"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;getTimeOfDay(F)F")})
    public float modifySkyDarken(float original) {
        ClientLevel level = (ClientLevel)this;
        BlockPos position = this.minecraft.gameRenderer.getMainCamera().getBlockPosition();
        if (WeatherGateClient.SUN_IN_BOX_LOCATIONS.containsKey(level.dimension())) {
            for (BlockPos blockPos : WeatherGateClient.SUN_IN_BOX_LOCATIONS.get(level.dimension())) {
                if (!RangeUtils.isWithinRange((Vec3i)blockPos, (Vec3i)position, 64)) continue;
                return 0.0f;
            }
        }
        return original;
    }

    @ModifyExpressionValue(method={"getCloudColor"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;getTimeOfDay(F)F")})
    public float modifyCouldColor(float original) {
        ClientLevel level = (ClientLevel)this;
        BlockPos position = this.minecraft.gameRenderer.getMainCamera().getBlockPosition();
        if (WeatherGateClient.SUN_IN_BOX_LOCATIONS.containsKey(level.dimension())) {
            for (BlockPos blockPos : WeatherGateClient.SUN_IN_BOX_LOCATIONS.get(level.dimension())) {
                if (!RangeUtils.isWithinRange((Vec3i)blockPos, (Vec3i)position, 64)) continue;
                return 0.0f;
            }
        }
        return original;
    }
}

