/*
 * Decompiled with CFR 0.152.
 */
package com.unrealdinnerbone.weathergate.network.packets.s2c.colorsync;

import com.mojang.logging.LogUtils;
import com.unrealdinnerbone.weathergate.WeatherGate;
import com.unrealdinnerbone.weathergate.WeatherGateCodecs;
import com.unrealdinnerbone.weathergate.client.WeatherGateClient;
import com.unrealdinnerbone.weathergate.util.Type;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.slf4j.Logger;

public record UpdateColorPacket(GlobalPos globalPos, Map<Type, Color4I> updateMap) implements CustomPacketPayload
{
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final CustomPacketPayload.Type<UpdateColorPacket> TYPE = new CustomPacketPayload.Type(WeatherGate.rl("update_color_packet"));
    public static final StreamCodec<FriendlyByteBuf, UpdateColorPacket> CODEC = StreamCodec.composite((StreamCodec)GlobalPos.STREAM_CODEC, UpdateColorPacket::globalPos, WeatherGateCodecs.MAP_STREAM_CODEC, UpdateColorPacket::updateMap, UpdateColorPacket::new);

    public static void handleUpdateColorPacket(UpdateColorPacket updateColorPacket, IPayloadContext context) {
        ResourceKey location = updateColorPacket.globalPos().dimension();
        if (WeatherGateClient.BLOCK_COLORS.containsKey(location)) {
            Map<BlockPos, Map<Type, Color4I>> blockPosMapMap = WeatherGateClient.BLOCK_COLORS.get(location);
            if (blockPosMapMap.containsKey(updateColorPacket.globalPos().pos())) {
                blockPosMapMap.get(updateColorPacket.globalPos().pos()).putAll(updateColorPacket.updateMap());
            } else {
                blockPosMapMap.put(updateColorPacket.globalPos().pos(), new HashMap<Type, Color4I>(updateColorPacket.updateMap()));
            }
            context.enqueueWork(() -> {
                if (WeatherGateClient.isPosInRange(updateColorPacket.globalPos().pos())) {
                    Minecraft.getInstance().levelRenderer.allChanged();
                }
            });
        } else {
            LOGGER.error("Failed to find block color map for {}", (Object)location);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

