/*
 * Decompiled with CFR 0.152.
 */
package terrails.xnetgases.module;

import java.util.LinkedList;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.IMekanismChemicalHandler;
import mekanism.api.chemical.ISidedChemicalHandler;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tier.ChemicalTankTier;
import mekanism.common.util.ChemicalUtil;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ChemicalMatcher
implements Predicate<ChemicalStack> {
    public static final ChemicalMatcher EMPTY = new ChemicalMatcher(ItemStack.EMPTY, Predicate.not(ChemicalStack::isEmpty));
    private static final Predicate<ChemicalStack> ALWAYS_FALSE = s -> false;
    private final ItemStack stack;
    private final Predicate<ChemicalStack> stackPredicate;

    public static ChemicalMatcher from(ItemStack stack) {
        if (stack != null && !stack.isEmpty()) {
            return Optional.ofNullable((IChemicalHandler)Capabilities.CHEMICAL.getCapability(stack)).map(handler -> handler.getChemicalInTank(0)).map(chemicalStack -> {
                if (chemicalStack.isEmpty()) {
                    return new ChemicalMatcher(new ItemStack((ItemLike)MekanismBlocks.CREATIVE_CHEMICAL_TANK), ALWAYS_FALSE);
                }
                Holder chemical = chemicalStack.getChemicalHolder();
                return new ChemicalMatcher(ChemicalUtil.getFullChemicalTank((ChemicalTankTier)ChemicalTankTier.CREATIVE, (Holder)chemical), s -> !s.isEmpty() && s.is(chemical));
            }).orElse(EMPTY);
        }
        return EMPTY;
    }

    private ChemicalMatcher(ItemStack stack, Predicate<ChemicalStack> stackPredicate) {
        this.stack = stack;
        this.stackPredicate = stackPredicate;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    public boolean test(ChemicalStack stack) {
        return this.stackPredicate.test(stack);
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    public long amountInTank(IChemicalHandler handler, @Nullable Direction direction) {
        IMekanismChemicalHandler mekHandler;
        if (handler instanceof IMekanismChemicalHandler && !(mekHandler = (IMekanismChemicalHandler)handler).canHandleChemicals()) {
            return 0L;
        }
        LinkedList<ChemicalStack> stacks = new LinkedList<ChemicalStack>();
        if (direction != null && handler instanceof ISidedChemicalHandler) {
            ISidedChemicalHandler sided = (ISidedChemicalHandler)handler;
            for (int i = 0; i < sided.getChemicalTanks(); ++i) {
                stacks.add(sided.getChemicalInTank(i, direction));
            }
        } else {
            for (int i = 0; i < handler.getChemicalTanks(); ++i) {
                stacks.add(handler.getChemicalInTank(i));
            }
        }
        return stacks.stream().filter(this).mapToLong(ChemicalStack::getAmount).sum();
    }
}

