/*
 * Decompiled with CFR 0.152.
 */
package com.mcdart.xp_synthesiser.blocks;

import com.mcdart.xp_synthesiser.XPSynthesiser;
import com.mcdart.xp_synthesiser.blocks.SynthesiserMenu;
import com.mcdart.xp_synthesiser.blocks.XPSynthesiserBlockEntity;
import com.mcdart.xp_synthesiser.items.KillRecorderData;
import com.mcdart.xp_synthesiser.items.KillRecorderItem;
import com.mcdart.xp_synthesiser.util.HelperFunctions;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class SynthesiserScreen
extends AbstractContainerScreen<SynthesiserMenu> {
    private static final int MAIN_SCREEN_HEIGHT = 166;
    private static final int MAIN_SCREEN_WIDTH = 176;
    private static final int LABEL_YPOS = 5;
    private static final int XP_LABEL_XPOS = 158;
    private static final int XP_LABEL_YPOS = 42;
    private static final int PROGRESS_LABEL_YPOS = 70;
    private static final int POWER_BAR_HEIGHT = 70;
    private static final int POWER_BAR_WIDTH = 16;
    private static final int POWER_BAR_X_OFFSET = 8;
    private static final int POWER_BAR_Y_OFFSET = 8;
    private static final int POWER_BAR_TEXTURE_X_OFFSET = 176;
    private static final int POWER_BAR_TEXTURE_Y_OFFSET = 2;
    private static final int PROGRESS_BAR_HEIGHT = 38;
    private static final int PROGRESS_BAR_WIDTH = 38;
    private static final int PROGRESS_BAR_X_OFFSET = 69;
    private static final int PROGRESS_BAR_Y_OFFSET = 27;
    private static final int PROGRESS_BAR_TEXTURE_X_OFFSET = 193;
    private static final int PROGRESS_BAR_TEXTURE_Y_OFFSET = 2;
    public static final int PLUS_ONE_BUTTON_ID = 1;
    public static final int MINUS_ONE_BUTTON_ID = 2;
    public static final int PLUS_TEN_BUTTON_ID = 3;
    public static final int MINUS_TEN_BUTTON_ID = 4;
    private static final int BUTTON_ONE_X_OFFSET = 149;
    private static final int BUTTON_TEN_X_OFFSET = 146;
    private static final int BUTTON_ONE_HEIGHT = 13;
    private static final int BUTTON_ONE_WIDTH = 17;
    private static final int BUTTON_TEN_HEIGHT = 13;
    private static final int BUTTON_TEN_WIDTH = 23;
    private static final ResourceLocation background = ResourceLocation.fromNamespaceAndPath((String)"xp_synthesiser", (String)"textures/gui/xp_synthesiser.png");

    public SynthesiserScreen(SynthesiserMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.titleLabelX = 10;
        this.inventoryLabelX = 10;
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    protected void init() {
        super.init();
        if (this.minecraft != null && this.minecraft.gameMode != null) {
            this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + 149, this.topPos + 25, 17, 13, new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"xp_synthesiser", (String)"button/plus_button_one"), ResourceLocation.fromNamespaceAndPath((String)"xp_synthesiser", (String)"button/plus_button_one")), element -> this.minecraft.gameMode.handleInventoryButtonClick(((SynthesiserMenu)this.menu).containerId, 1)));
            this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + 149, this.topPos + 42 + 11, 17, 13, new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"xp_synthesiser", (String)"button/minus_button_one"), ResourceLocation.fromNamespaceAndPath((String)"xp_synthesiser", (String)"button/minus_button_one")), element -> this.minecraft.gameMode.handleInventoryButtonClick(((SynthesiserMenu)this.menu).containerId, 2)));
            this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + 146, this.topPos + 10, 23, 13, new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"xp_synthesiser", (String)"button/plus_button_ten"), ResourceLocation.fromNamespaceAndPath((String)"xp_synthesiser", (String)"button/plus_button_ten")), element -> this.minecraft.gameMode.handleInventoryButtonClick(((SynthesiserMenu)this.menu).containerId, 3)));
            this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + 146, this.topPos + 42 + 26, 23, 13, new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"xp_synthesiser", (String)"button/minus_button_ten"), ResourceLocation.fromNamespaceAndPath((String)"xp_synthesiser", (String)"button/minus_button_ten")), element -> this.minecraft.gameMode.handleInventoryButtonClick(((SynthesiserMenu)this.menu).containerId, 4)));
        }
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(graphics, mouseX, mouseY, partialTick);
        super.render(graphics, mouseX, mouseY, partialTick);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    public void renderBg(GuiGraphics graphics, float pPartialTick, int mouseX, int mouseY) {
        int energyToDisplay;
        graphics.blit(background, this.leftPos, this.topPos, 0, 0, 176, 166);
        XPSynthesiserBlockEntity synthesiser = ((SynthesiserMenu)this.menu).getSynthesiser();
        if (synthesiser.trackedEnergy.get(1) > 0) {
            double powerPercentage = (double)synthesiser.trackedEnergy.get(1) / (double)synthesiser.energyStorage.getMaxEnergyStored();
            graphics.blit(background, this.leftPos + 8, this.topPos + 8 + (int)Math.floor(70.0 - 70.0 * powerPercentage), 176, 2, 16, (int)Math.ceil(70.0 * powerPercentage));
        }
        KillRecorderData killRecorderData = (KillRecorderData)synthesiser.itemHandler.getStackInSlot(0).getOrDefault((DataComponentType)XPSynthesiser.KILL_RECORDER_DATA_COMPONENT.get(), (Object)KillRecorderData.createEmpty());
        if (synthesiser.trackedProgress.get(0) > 0 && killRecorderData.recordingEnd() > 0L) {
            int progress = synthesiser.trackedProgress.get(0);
            double completionPercentage = (double)progress / (double)(killRecorderData.recordingEnd() - killRecorderData.recordingStart());
            graphics.blit(background, this.leftPos + 69, this.topPos + 27 + (int)Math.floor(38.0 - 38.0 * completionPercentage), 193, 2 + (int)Math.floor(38.0 - 38.0 * completionPercentage), 38, (int)Math.ceil(38.0 * completionPercentage));
        }
        int n = energyToDisplay = synthesiser.trackedEnergy.get(1) > synthesiser.energyStorage.getMaxEnergyStored() - 2 ? synthesiser.energyStorage.getMaxEnergyStored() : synthesiser.trackedEnergy.get(1);
        if (mouseX > this.leftPos + 8 && mouseX < this.leftPos + 8 + 16 && mouseY > this.topPos + 8 && mouseY < this.topPos + 8 + 70) {
            graphics.renderTooltip(this.font, Language.getInstance().getVisualOrder(List.of(Component.literal((String)(String.valueOf(energyToDisplay > 1000 ? energyToDisplay / 1000 + " k" : Integer.valueOf(energyToDisplay)) + "FE/1000 kFE")))), mouseX, mouseY);
        }
        if (!(synthesiser.itemHandler.getStackInSlot(0).getItem() instanceof KillRecorderItem) && mouseX > this.leftPos + 80 && mouseX < this.leftPos + 80 + 18 && mouseY > this.topPos + 38 && mouseY < this.topPos + 38 + 18) {
            graphics.renderTooltip(this.font, Language.getInstance().getVisualOrder(List.of(Component.literal((String)"Kill Recorder necessary to run"))), mouseX, mouseY);
        }
        if (mouseX > this.leftPos + 158 - 15 && mouseX < this.leftPos + 158 + 15 && mouseY > this.topPos + 42 - 2 && mouseY < this.topPos + 42 + 8) {
            graphics.renderTooltip(this.font, Language.getInstance().getVisualOrder(List.of(Component.literal((String)"XP Levels stored"))), mouseX, mouseY);
        }
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        XPSynthesiserBlockEntity synthesiser = ((SynthesiserMenu)this.menu).getSynthesiser();
        MutableComponent title = Component.translatable((String)"block.xp_synthesiser.xp_synthesiser");
        graphics.drawString(this.font, (Component)title, (this.imageWidth - this.font.width((FormattedText)title)) / 2, 5, -12566464, false);
        MutableComponent xpAmount = Component.literal((String)String.valueOf(HelperFunctions.roundTo(HelperFunctions.getLevelFromXP(synthesiser.trackedProgress.get(1)), 2)));
        graphics.drawString(this.font, (Component)xpAmount, 158 - this.font.width((FormattedText)xpAmount) / 2, 42, 235780, false);
        if (!synthesiser.itemHandler.getStackInSlot(0).equals(ItemStack.EMPTY) && synthesiser.itemHandler.getStackInSlot(0).getItem() instanceof KillRecorderItem) {
            KillRecorderData killRecorderData = (KillRecorderData)synthesiser.itemHandler.getStackInSlot(0).getOrDefault((DataComponentType)XPSynthesiser.KILL_RECORDER_DATA_COMPONENT.get(), (Object)KillRecorderData.createEmpty());
            if (killRecorderData.recordingEnd() == 0L) {
                MutableComponent noValidRecording = Component.literal((String)"NO VALID RECORDING");
                graphics.drawString(this.font, (Component)noValidRecording, (this.imageWidth - this.font.width((FormattedText)noValidRecording)) / 2 + 1, 70, 0xFF0000, false);
            } else if (HelperFunctions.getTickCost(killRecorderData.xp(), (int)(killRecorderData.recordingEnd() - killRecorderData.recordingStart())) > (double)synthesiser.trackedEnergy.get(1)) {
                MutableComponent notEnoughPower = Component.literal((String)"NOT ENOUGH POWER");
                graphics.drawString(this.font, (Component)notEnoughPower, (this.imageWidth - this.font.width((FormattedText)notEnoughPower)) / 2 + 1, 70, 0xFF0000, false);
            } else {
                MutableComponent progressAmount = Component.literal((String)(Math.min((int)Math.ceil((double)synthesiser.trackedProgress.get(0) / (double)(killRecorderData.recordingEnd() - killRecorderData.recordingStart()) * 100.0 + 2.0), 100) + "%"));
                graphics.drawString(this.font, (Component)progressAmount, (this.imageWidth - this.font.width((FormattedText)progressAmount)) / 2 + 1, 70, -12566464, false);
            }
        }
    }
}

