/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.ChunkWatchEvent;
import tv.soaryn.xycraft.core.XyCore;
import tv.soaryn.xycraft.core.content.attachments.accessors.FavoredColor;
import tv.soaryn.xycraft.core.network.packets.CBPlayerColorSyncPacket;

public class XyCoreCommon {

    @EventBusSubscriber(modid="xycraft_core", bus=EventBusSubscriber.Bus.GAME)
    static interface NeoForgeBus {
        @SubscribeEvent
        public static void onChunkSent(ChunkWatchEvent.Sent event) {
            ServerPlayer player = event.getPlayer();
            int color = FavoredColor.of((IAttachmentHolder)player);
            XyCore.Network.broadcast(new CBPlayerColorSyncPacket(player.getId(), color));
            for (Player otherPlayer : player.level().players()) {
                if (otherPlayer.equals((Object)player)) continue;
                XyCore.Network.send((Player)player, new CBPlayerColorSyncPacket(otherPlayer.getId(), FavoredColor.of((IAttachmentHolder)otherPlayer)));
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            XyCore.Network.broadcast(new CBPlayerColorSyncPacket(player.getId(), FavoredColor.of((IAttachmentHolder)player)));
            for (Player otherPlayer : player.level().players()) {
                if (otherPlayer.equals((Object)player)) continue;
                XyCore.Network.send(player, new CBPlayerColorSyncPacket(otherPlayer.getId(), FavoredColor.of((IAttachmentHolder)otherPlayer)));
            }
        }
    }
}

