/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content.systems;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import java.util.Objects;
import java.util.Set;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;
import tv.soaryn.xycraft.core.content.systems.ISystemData;
import tv.soaryn.xycraft.core.utils.serialization.CodecUtils;

public class BlockTickSystemLevelAttachment
implements ISystemData {
    public static final Codec<BlockTickSystemLevelAttachment> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)CodecUtils.tupleOf(Codec.LONG, NeoForgeExtraCodecs.setOf((Codec)Codec.LONG).xmap(LongArraySet::new, Set::copyOf), Long2ObjectOpenHashMap::new).fieldOf("chunk_map").forGetter(data -> data.ChunkMap), (App)Codec.LONG.fieldOf("frequency").forGetter(BlockTickSystemLevelAttachment::frequency), (App)Codec.BOOL.fieldOf("enabled").forGetter(BlockTickSystemLevelAttachment::enabled)).apply((Applicative)builder, BlockTickSystemLevelAttachment::new));
    public static final AttachmentType.Builder<BlockTickSystemLevelAttachment> Builder = AttachmentType.builder(() -> new BlockTickSystemLevelAttachment(5L, true)).serialize(CODEC);
    public final Long2ObjectOpenHashMap<LongArraySet> ChunkMap = new Long2ObjectOpenHashMap();
    private boolean _enabled;
    private long _frequency;

    public static AttachmentType.Builder<BlockTickSystemLevelAttachment> builder(long freq) {
        return AttachmentType.builder(() -> new BlockTickSystemLevelAttachment(freq, true)).serialize(CODEC);
    }

    public static AttachmentType.Builder<BlockTickSystemLevelAttachment> builder(long freq, boolean state) {
        return AttachmentType.builder(() -> new BlockTickSystemLevelAttachment(freq, state)).serialize(CODEC);
    }

    protected BlockTickSystemLevelAttachment(long freq, boolean state) {
        this._frequency = freq;
        this._enabled = state;
    }

    protected BlockTickSystemLevelAttachment(Long2ObjectOpenHashMap<LongArraySet> chunkMap, long frequency, boolean enabled) {
        this.ChunkMap.putAll(chunkMap);
        this._frequency = frequency;
        this._enabled = enabled;
    }

    public Long2ObjectOpenHashMap<LongArraySet> map() {
        return this.ChunkMap;
    }

    @Override
    public long frequency() {
        return this._frequency;
    }

    @Override
    public boolean enabled() {
        return this._enabled;
    }

    @Override
    public void setEnabled(boolean value) {
        this._enabled = value;
    }

    @Override
    public void setFrequency(long frequency) {
        this._frequency = frequency;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        BlockTickSystemLevelAttachment that = (BlockTickSystemLevelAttachment)obj;
        return Objects.equals(this.ChunkMap, that.ChunkMap);
    }

    public int hashCode() {
        return Objects.hash(this.ChunkMap);
    }

    public String toString() {
        return "SystemPositionCache{[Enabled: %s]  [Frequency: %d] --- [ChunkMap: %s]}".formatted(this._enabled, this._frequency, this.ChunkMap);
    }
}

