/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.utils;

import java.util.Arrays;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.crafting.IntersectionIngredient;
import tv.soaryn.xycraft.api.content.XyCraftColors;
import tv.soaryn.xycraft.core.content.Tag;
import tv.soaryn.xycraft.core.content.XyCraftTags;

public final class IngredientUtils {
    private IngredientUtils() {
    }

    @SafeVarargs
    public static Ingredient composite(TagKey<Item> ... tags) {
        return IntersectionIngredient.of((Ingredient[])((Ingredient[])Arrays.stream(tags).map(Ingredient::of).toArray(Ingredient[]::new)));
    }

    @SafeVarargs
    public static Ingredient composite(Tag<Item> ... tags) {
        return IntersectionIngredient.of((Ingredient[])((Ingredient[])Arrays.stream(tags).map(Tag::tag).map(Ingredient::of).toArray(Ingredient[]::new)));
    }

    public static Ingredient withColor(Tag<Item> tag, XyCraftColors color) {
        return IngredientUtils.composite(tag, XyCraftTags.Items.XyColor.get(color));
    }
}

