/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.attachments;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.container.item.ItemContainer;
import tv.soaryn.xycraft.core.container.item.SimpleItemContainer;
import tv.soaryn.xycraft.core.utils.AttachmentUtils;
import tv.soaryn.xycraft.core.utils.handlers.HandlerIOBehavior;
import tv.soaryn.xycraft.core.utils.serialization.CodecUtils;

public class BufferBlockAttachment {
    private static final Codec<BufferBlockAttachment> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)CodecUtils.Codecs.ITEM_STACK_OPTIONAL.listOf().fieldOf("items").forGetter(data -> data.Inventory.copyToList())).apply((Applicative)builder, BufferBlockAttachment::new));
    public static final AttachmentType.Builder<BufferBlockAttachment> BUILDER = AttachmentUtils.createBuilder(BufferBlockAttachment::new, CODEC, (data, holder) -> {
        data._blockEntity = (BlockEntity)holder;
    });
    public final ItemContainer Inventory = new SimpleItemContainer(15, this::setChanged);
    public final IItemHandler North = this.Inventory.asHandler(BufferBlockAttachment.createBehavior(0, 3));
    public final IItemHandler West = this.Inventory.asHandler(BufferBlockAttachment.createBehavior(3, 6));
    public final IItemHandler Bottom = this.Inventory.asHandler(BufferBlockAttachment.createBehavior(6, 9));
    public final IItemHandler East = this.Inventory.asHandler(BufferBlockAttachment.createBehavior(9, 12));
    public final IItemHandler South = this.Inventory.asHandler(BufferBlockAttachment.createBehavior(12, 15));
    public final IItemHandler Top = this.Inventory.asHandler();
    private BlockEntity _blockEntity;

    public BufferBlockAttachment(IAttachmentHolder holder) {
        this._blockEntity = (BlockEntity)holder;
    }

    public BufferBlockAttachment(List<ItemStack> items) {
        for (int i = 0; i < items.size(); ++i) {
            this.Inventory.set(i, items.get(i));
        }
    }

    @NotNull
    private static HandlerIOBehavior createBehavior(final int min, final int max) {
        return new HandlerIOBehavior(){
            final int minSlot;
            final int maxSlot;
            {
                this.minSlot = min;
                this.maxSlot = max;
            }

            public boolean canInsert(int slot) {
                return slot >= this.minSlot && slot < this.maxSlot && super.canInsert(slot);
            }

            public boolean canExtract(int slot) {
                return slot >= this.minSlot && slot < this.maxSlot && super.canExtract(slot);
            }
        };
    }

    private void setChanged() {
        if (this._blockEntity != null) {
            this._blockEntity.setChanged();
        }
    }
}

