/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.recipes.producers.extractor;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.content.recipe.IRecipeContainer;
import tv.soaryn.xycraft.core.content.recipe.IRecipeContent;
import tv.soaryn.xycraft.core.content.recipe.RecipeContent;
import tv.soaryn.xycraft.core.content.recipe.RecipeSerDes;
import tv.soaryn.xycraft.core.utils.rules.IRule;
import tv.soaryn.xycraft.core.utils.serialization.BinarySerializer;
import tv.soaryn.xycraft.core.utils.serialization.CodecUtils;
import tv.soaryn.xycraft.core.utils.serialization.Serializer;
import tv.soaryn.xycraft.machines.content.registries.MachinesRecipeTypes;

public record ExtractorRecipe(Either<FluidStack, ItemStack> output, IRule target, EnumSet<Direction> validDirections, ArrayList<IRule> adjacentRules, Optional<IRule> catalyst, Optional<FluidType> waterloggedFluid, long ticks, boolean hidden) implements IRecipeContent<Input, ExtractorRecipe>
{
    private static final MapCodec<ExtractorRecipe> codec = RecordCodecBuilder.mapCodec(builder -> builder.group((App)CodecUtils.Codecs.ContentObject.fieldOf("output").forGetter(ExtractorRecipe::output), (App)IRule.RULE_CODEC.fieldOf("target").forGetter(ExtractorRecipe::target), (App)Direction.CODEC.listOf().optionalFieldOf("valid_directions", EnumSet.allOf(Direction.class).stream().toList()).xmap(EnumSet::copyOf, List::copyOf).orElse(EnumSet.noneOf(Direction.class)).forGetter(ExtractorRecipe::validDirections), (App)IRule.RULE_CODEC.listOf().optionalFieldOf("adjacent", List.of()).xmap(ArrayList::new, ArrayList::new).forGetter(ExtractorRecipe::adjacentRules), (App)IRule.RULE_CODEC.optionalFieldOf("catalyst").forGetter(ExtractorRecipe::catalyst), (App)NeoForgeRegistries.FLUID_TYPES.byNameCodec().optionalFieldOf("waterlogged_fluid").forGetter(ExtractorRecipe::waterloggedFluid), (App)Codec.LONG.fieldOf("ticks").forGetter(ExtractorRecipe::ticks), (App)Codec.BOOL.optionalFieldOf("hidden", (Object)false).forGetter(ExtractorRecipe::hidden)).apply((Applicative)builder, ExtractorRecipe::new));
    private static final BinarySerializer<ExtractorRecipe> SerDes = BinarySerializer.ofType(ExtractorRecipe::new, ExtractorRecipe::output, (BinarySerializer)RecipeSerDes.OutputObjectSerDes, ExtractorRecipe::target, (BinarySerializer)IRule.SerDes, ExtractorRecipe::validDirections, (BinarySerializer)BinarySerializer.ofCollection(() -> EnumSet.noneOf(Direction.class), (BinarySerializer)BinarySerializer.ofEnum(Direction.class)), ExtractorRecipe::adjacentRules, (BinarySerializer)BinarySerializer.ofCollection(ArrayList::new, (BinarySerializer)IRule.SerDes), ExtractorRecipe::catalyst, (BinarySerializer)BinarySerializer.optionalOf((BinarySerializer)IRule.SerDes), ExtractorRecipe::waterloggedFluid, (BinarySerializer)BinarySerializer.optionalOf((BinarySerializer)Serializer.FLUID_TYPE), ExtractorRecipe::ticks, (BinarySerializer)Serializer.LONG, ExtractorRecipe::hidden, (BinarySerializer)Serializer.BOOLEAN);

    public static RecipeSerDes<ExtractorRecipe> register() {
        return RecipeSerDes.create(codec, SerDes);
    }

    public RecipeContent<ExtractorRecipe> getContent() {
        return MachinesRecipeTypes.Extractor;
    }

    public ArrayList<IRule> getAllRules() {
        ArrayList<IRule> list = new ArrayList<IRule>();
        list.add(this.target());
        if (this.catalyst().isPresent()) {
            list.add(this.catalyst().get());
        }
        list.addAll(this.adjacentRules());
        return list;
    }

    public boolean isFluidRecipe() {
        return this.output().left().isPresent();
    }

    @NotNull
    public FluidStack getFluidOutput() {
        return this.output().left().orElse(FluidStack.EMPTY).copy();
    }

    @NotNull
    public ItemStack getItemOutput() {
        return this.output().right().orElse(ItemStack.EMPTY).copy();
    }

    public boolean matches(Input input, @NotNull Level level) {
        if (!this.validDirections.contains(input.getDirection()) || !this.target.matches(input.getTarget()) || this.catalyst.isPresent() && !this.catalyst.get().matches(input.getCatalyst()) || this.waterloggedFluid.isPresent() && input.getFluidState().getFluidType() != this.waterloggedFluid.get()) {
            return false;
        }
        if (this.adjacentRules.isEmpty()) {
            return true;
        }
        ArrayList<IRule> ruleTests = new ArrayList<IRule>(this.adjacentRules);
        List<BlockState> states = input.computeAdjacent();
        ruleTests.removeIf(ruleTest -> {
            for (BlockState state : states) {
                if (!ruleTest.matches(state)) continue;
                states.remove(state);
                return true;
            }
            return false;
        });
        return ruleTests.isEmpty();
    }

    public static interface Input
    extends IRecipeContainer {
        public Direction getDirection();

        public FluidState getFluidState();

        public BlockState getTarget();

        public BlockState getCatalyst();

        public List<BlockState> computeAdjacent();
    }
}

