/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.network;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import tv.soaryn.xycraft.api.content.capabilities.PipeConnectionType;
import tv.soaryn.xycraft.core.network.Packet;
import tv.soaryn.xycraft.core.utils.serialization.BinarySerializer;
import tv.soaryn.xycraft.core.utils.serialization.Serializer;
import tv.soaryn.xycraft.machines.content.blocks.pipe.PipeConnectionAttachment;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;

public record CBPipeUpdatePacket(BlockPos pos, Reference2ReferenceMap<Direction, PipeConnectionType> connectionLogicMap) implements Packet.ClientBound
{
    public static final BinarySerializer<CBPipeUpdatePacket> SerDes = BinarySerializer.ofType(CBPipeUpdatePacket::new, CBPipeUpdatePacket::pos, (BinarySerializer)Serializer.BLOCK_POS, CBPipeUpdatePacket::connectionLogicMap, (BinarySerializer)BinarySerializer.ofMap(Reference2ReferenceOpenHashMap::new, (BinarySerializer)BinarySerializer.ofEnum(Direction.class), (BinarySerializer)BinarySerializer.ofEnum(PipeConnectionType.class)));

    public void handle(Packet.ClientBound.Context context) {
        context.enqueueMainThread(() -> {
            Level level = context.player().level();
            BlockEntity blockEntity = level.getBlockEntity(this.pos());
            if (blockEntity == null) {
                return;
            }
            PipeConnectionAttachment data = (PipeConnectionAttachment)blockEntity.getData(MachinesAttachments.Block.PipeConnectionData);
            data.map().putAll(this.connectionLogicMap);
            blockEntity.setChanged();
            BlockState state = blockEntity.getBlockState();
            level.sendBlockUpdated(this.pos, state, state, 3);
            level.markAndNotifyBlock(this.pos, level.getChunkAt(this.pos), state, state, 3, 512);
            blockEntity.requestModelDataUpdate();
        });
    }
}

