/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.pipeline;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;

public class MainTarget
extends RenderTarget {
    public static final int DEFAULT_WIDTH = 854;
    public static final int DEFAULT_HEIGHT = 480;
    static final Dimension DEFAULT_DIMENSIONS = new Dimension(854, 480);

    public MainTarget(int p_166137_, int p_166138_) {
        super(true);
        this.createFrameBuffer(p_166137_, p_166138_);
    }

    private void createFrameBuffer(int p_166142_, int p_166143_) {
        Dimension $$2 = this.allocateAttachments(p_166142_, p_166143_);
        this.frameBufferId = GlStateManager.glGenFramebuffers();
        GlStateManager._glBindFramebuffer(36160, this.frameBufferId);
        GlStateManager._bindTexture(this.colorTextureId);
        GlStateManager._texParameter(3553, 10241, 9728);
        GlStateManager._texParameter(3553, 10240, 9728);
        GlStateManager._texParameter(3553, 10242, 33071);
        GlStateManager._texParameter(3553, 10243, 33071);
        GlStateManager._glFramebufferTexture2D(36160, 36064, 3553, this.colorTextureId, 0);
        GlStateManager._bindTexture(this.depthBufferId);
        GlStateManager._texParameter(3553, 34892, 0);
        GlStateManager._texParameter(3553, 10241, 9728);
        GlStateManager._texParameter(3553, 10240, 9728);
        GlStateManager._texParameter(3553, 10242, 33071);
        GlStateManager._texParameter(3553, 10243, 33071);
        GlStateManager._glFramebufferTexture2D(36160, 36096, 3553, this.depthBufferId, 0);
        GlStateManager._bindTexture(0);
        this.viewWidth = $$2.width;
        this.viewHeight = $$2.height;
        this.width = $$2.width;
        this.height = $$2.height;
        this.checkStatus();
        GlStateManager._glBindFramebuffer(36160, 0);
    }

    private Dimension allocateAttachments(int p_166147_, int p_166148_) {
        RenderSystem.assertOnRenderThreadOrInit();
        this.colorTextureId = TextureUtil.generateTextureId();
        this.depthBufferId = TextureUtil.generateTextureId();
        AttachmentState $$2 = AttachmentState.NONE;
        for (Dimension $$3 : Dimension.listWithFallback(p_166147_, p_166148_)) {
            $$2 = AttachmentState.NONE;
            if (this.allocateColorAttachment($$3)) {
                $$2 = $$2.with(AttachmentState.COLOR);
            }
            if (this.allocateDepthAttachment($$3)) {
                $$2 = $$2.with(AttachmentState.DEPTH);
            }
            if ($$2 != AttachmentState.COLOR_DEPTH) continue;
            return $$3;
        }
        throw new RuntimeException("Unrecoverable GL_OUT_OF_MEMORY (allocated attachments = " + $$2.name() + ")");
    }

    private boolean allocateColorAttachment(Dimension p_166140_) {
        RenderSystem.assertOnRenderThreadOrInit();
        GlStateManager._getError();
        GlStateManager._bindTexture(this.colorTextureId);
        GlStateManager._texImage2D(3553, 0, 32856, p_166140_.width, p_166140_.height, 0, 6408, 5121, null);
        return GlStateManager._getError() != 1285;
    }

    private boolean allocateDepthAttachment(Dimension p_166145_) {
        RenderSystem.assertOnRenderThreadOrInit();
        GlStateManager._getError();
        GlStateManager._bindTexture(this.depthBufferId);
        GlStateManager._texImage2D(3553, 0, 6402, p_166145_.width, p_166145_.height, 0, 6402, 5126, null);
        return GlStateManager._getError() != 1285;
    }

    static class Dimension {
        public final int width;
        public final int height;

        Dimension(int p_166171_, int p_166172_) {
            this.width = p_166171_;
            this.height = p_166172_;
        }

        static List<Dimension> listWithFallback(int p_166174_, int p_166175_) {
            RenderSystem.assertOnRenderThreadOrInit();
            int $$2 = RenderSystem.maxSupportedTextureSize();
            if (p_166174_ <= 0 || p_166174_ > $$2 || p_166175_ <= 0 || p_166175_ > $$2) {
                return ImmutableList.of((Object)DEFAULT_DIMENSIONS);
            }
            return ImmutableList.of((Object)new Dimension(p_166174_, p_166175_), (Object)DEFAULT_DIMENSIONS);
        }

        public boolean equals(Object p_166177_) {
            if (this == p_166177_) {
                return true;
            }
            if (p_166177_ == null || this.getClass() != p_166177_.getClass()) {
                return false;
            }
            Dimension $$1 = (Dimension)p_166177_;
            return this.width == $$1.width && this.height == $$1.height;
        }

        public int hashCode() {
            return Objects.hash(this.width, this.height);
        }

        public String toString() {
            return this.width + "x" + this.height;
        }
    }

    static enum AttachmentState {
        NONE,
        COLOR,
        DEPTH,
        COLOR_DEPTH;

        private static final AttachmentState[] VALUES;

        AttachmentState with(AttachmentState p_166164_) {
            return VALUES[this.ordinal() | p_166164_.ordinal()];
        }

        static {
            VALUES = AttachmentState.values();
        }
    }
}

