/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;

public record StatePropertiesPredicate(List<PropertyMatcher> properties) {
    private static final Codec<List<PropertyMatcher>> PROPERTIES_CODEC = Codec.unboundedMap((Codec)Codec.STRING, ValueMatcher.CODEC).xmap(p_297916_ -> p_297916_.entrySet().stream().map(p_297914_ -> new PropertyMatcher((String)p_297914_.getKey(), (ValueMatcher)p_297914_.getValue())).toList(), p_297915_ -> p_297915_.stream().collect(Collectors.toMap(PropertyMatcher::name, PropertyMatcher::valueMatcher)));
    public static final Codec<StatePropertiesPredicate> CODEC = PROPERTIES_CODEC.xmap(StatePropertiesPredicate::new, StatePropertiesPredicate::properties);
    public static final StreamCodec<ByteBuf, StatePropertiesPredicate> STREAM_CODEC = PropertyMatcher.STREAM_CODEC.apply(ByteBufCodecs.list()).map(StatePropertiesPredicate::new, StatePropertiesPredicate::properties);

    public <S extends StateHolder<?, S>> boolean matches(StateDefinition<?, S> p_67670_, S p_67671_) {
        for (PropertyMatcher $$2 : this.properties) {
            if ($$2.match(p_67670_, p_67671_)) continue;
            return false;
        }
        return true;
    }

    public boolean matches(BlockState p_67668_) {
        return this.matches(p_67668_.getBlock().getStateDefinition(), p_67668_);
    }

    public boolean matches(FluidState p_67685_) {
        return this.matches(p_67685_.getType().getStateDefinition(), p_67685_);
    }

    public Optional<String> checkState(StateDefinition<?, ?> p_298590_) {
        for (PropertyMatcher $$1 : this.properties) {
            Optional<String> $$2 = $$1.checkState(p_298590_);
            if (!$$2.isPresent()) continue;
            return $$2;
        }
        return Optional.empty();
    }

    record PropertyMatcher(String name, ValueMatcher valueMatcher) {
        public static final StreamCodec<ByteBuf, PropertyMatcher> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.STRING_UTF8, PropertyMatcher::name, ValueMatcher.STREAM_CODEC, PropertyMatcher::valueMatcher, PropertyMatcher::new);

        public <S extends StateHolder<?, S>> boolean match(StateDefinition<?, S> p_67719_, S p_67720_) {
            Property<?> $$2 = p_67719_.getProperty(this.name);
            return $$2 != null && this.valueMatcher.match(p_67720_, $$2);
        }

        public Optional<String> checkState(StateDefinition<?, ?> p_67722_) {
            Property<?> $$1 = p_67722_.getProperty(this.name);
            return $$1 != null ? Optional.empty() : Optional.of(this.name);
        }
    }

    static interface ValueMatcher {
        public static final Codec<ValueMatcher> CODEC = Codec.either(ExactMatcher.CODEC, RangedMatcher.CODEC).xmap(Either::unwrap, p_299089_ -> {
            if (p_299089_ instanceof ExactMatcher) {
                ExactMatcher $$1 = (ExactMatcher)p_299089_;
                return Either.left((Object)$$1);
            }
            if (p_299089_ instanceof RangedMatcher) {
                RangedMatcher $$2 = (RangedMatcher)p_299089_;
                return Either.right((Object)$$2);
            }
            throw new UnsupportedOperationException();
        });
        public static final StreamCodec<ByteBuf, ValueMatcher> STREAM_CODEC = ByteBufCodecs.either(ExactMatcher.STREAM_CODEC, RangedMatcher.STREAM_CODEC).map(Either::unwrap, p_329686_ -> {
            if (p_329686_ instanceof ExactMatcher) {
                ExactMatcher $$1 = (ExactMatcher)p_329686_;
                return Either.left((Object)$$1);
            }
            if (p_329686_ instanceof RangedMatcher) {
                RangedMatcher $$2 = (RangedMatcher)p_329686_;
                return Either.right((Object)$$2);
            }
            throw new UnsupportedOperationException();
        });

        public <T extends Comparable<T>> boolean match(StateHolder<?, ?> var1, Property<T> var2);
    }

    public static class Builder {
        private final ImmutableList.Builder<PropertyMatcher> matchers = ImmutableList.builder();

        private Builder() {
        }

        public static Builder properties() {
            return new Builder();
        }

        public Builder hasProperty(Property<?> p_67701_, String p_67702_) {
            this.matchers.add((Object)new PropertyMatcher(p_67701_.getName(), new ExactMatcher(p_67702_)));
            return this;
        }

        public Builder hasProperty(Property<Integer> p_67695_, int p_67696_) {
            return this.hasProperty((Property)p_67695_, (Comparable<T> & StringRepresentable)Integer.toString(p_67696_));
        }

        public Builder hasProperty(Property<Boolean> p_67704_, boolean p_67705_) {
            return this.hasProperty((Property)p_67704_, (Comparable<T> & StringRepresentable)Boolean.toString(p_67705_));
        }

        public <T extends Comparable<T> & StringRepresentable> Builder hasProperty(Property<T> p_67698_, T p_67699_) {
            return this.hasProperty(p_67698_, (T)((StringRepresentable)p_67699_).getSerializedName());
        }

        public Optional<StatePropertiesPredicate> build() {
            return Optional.of(new StatePropertiesPredicate((List<PropertyMatcher>)this.matchers.build()));
        }
    }

    record RangedMatcher(Optional<String> minValue, Optional<String> maxValue) implements ValueMatcher
    {
        public static final Codec<RangedMatcher> CODEC = RecordCodecBuilder.create(p_337397_ -> p_337397_.group((App)Codec.STRING.optionalFieldOf("min").forGetter(RangedMatcher::minValue), (App)Codec.STRING.optionalFieldOf("max").forGetter(RangedMatcher::maxValue)).apply((Applicative)p_337397_, RangedMatcher::new));
        public static final StreamCodec<ByteBuf, RangedMatcher> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.optional(ByteBufCodecs.STRING_UTF8), RangedMatcher::minValue, ByteBufCodecs.optional(ByteBufCodecs.STRING_UTF8), RangedMatcher::maxValue, RangedMatcher::new);

        @Override
        public <T extends Comparable<T>> boolean match(StateHolder<?, ?> p_298772_, Property<T> p_298371_) {
            Optional<T> $$4;
            Optional<T> $$3;
            Comparable $$2 = p_298772_.getValue(p_298371_);
            if (this.minValue.isPresent() && (($$3 = p_298371_.getValue(this.minValue.get())).isEmpty() || $$2.compareTo((Comparable)((Comparable)$$3.get())) < 0)) {
                return false;
            }
            return !this.maxValue.isPresent() || !($$4 = p_298371_.getValue(this.maxValue.get())).isEmpty() && $$2.compareTo((Comparable)((Comparable)$$4.get())) <= 0;
        }
    }

    record ExactMatcher(String value) implements ValueMatcher
    {
        public static final Codec<ExactMatcher> CODEC = Codec.STRING.xmap(ExactMatcher::new, ExactMatcher::value);
        public static final StreamCodec<ByteBuf, ExactMatcher> STREAM_CODEC = ByteBufCodecs.STRING_UTF8.map(ExactMatcher::new, ExactMatcher::value);

        @Override
        public <T extends Comparable<T>> boolean match(StateHolder<?, ?> p_298379_, Property<T> p_299294_) {
            Comparable $$2 = p_298379_.getValue(p_299294_);
            Optional<T> $$3 = p_299294_.getValue(this.value);
            return $$3.isPresent() && $$2.compareTo((Comparable)((Comparable)$$3.get())) == 0;
        }
    }
}

