/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.components.toasts;

import com.google.common.collect.Queues;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Deque;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.util.Mth;

public class ToastComponent {
    private static final int SLOT_COUNT = 5;
    private static final int NO_SPACE = -1;
    final Minecraft minecraft;
    private final List<ToastInstance<?>> visible = new ArrayList();
    private final BitSet occupiedSlots = new BitSet(5);
    private final Deque<Toast> queued = Queues.newArrayDeque();

    public ToastComponent(Minecraft p_94918_) {
        this.minecraft = p_94918_;
    }

    public void render(GuiGraphics p_283249_) {
        if (this.minecraft.options.hideGui) {
            return;
        }
        int $$1 = p_283249_.guiWidth();
        this.visible.removeIf(p_280780_ -> {
            if (p_280780_ != null && p_280780_.render($$1, p_283249_)) {
                this.occupiedSlots.clear(p_280780_.index, p_280780_.index + p_280780_.slotCount);
                return true;
            }
            return false;
        });
        if (!this.queued.isEmpty() && this.freeSlots() > 0) {
            this.queued.removeIf(p_243239_ -> {
                int $$1 = p_243239_.slotCount();
                int $$2 = this.findFreeIndex($$1);
                if ($$2 != -1) {
                    this.visible.add(new ToastInstance(this, p_243239_, $$2, $$1));
                    this.occupiedSlots.set($$2, $$2 + $$1);
                    return true;
                }
                return false;
            });
        }
    }

    private int findFreeIndex(int p_243272_) {
        if (this.freeSlots() >= p_243272_) {
            int $$1 = 0;
            for (int $$2 = 0; $$2 < 5; ++$$2) {
                if (this.occupiedSlots.get($$2)) {
                    $$1 = 0;
                    continue;
                }
                if (++$$1 != p_243272_) continue;
                return $$2 + 1 - $$1;
            }
        }
        return -1;
    }

    private int freeSlots() {
        return 5 - this.occupiedSlots.cardinality();
    }

    @Nullable
    public <T extends Toast> T getToast(Class<? extends T> p_94927_, Object p_94928_) {
        for (ToastInstance<?> $$2 : this.visible) {
            if ($$2 == null || !p_94927_.isAssignableFrom($$2.getToast().getClass()) || !$$2.getToast().getToken().equals(p_94928_)) continue;
            return (T)$$2.getToast();
        }
        for (Toast $$3 : this.queued) {
            if (!p_94927_.isAssignableFrom($$3.getClass()) || !$$3.getToken().equals(p_94928_)) continue;
            return (T)$$3;
        }
        return null;
    }

    public void clear() {
        this.occupiedSlots.clear();
        this.visible.clear();
        this.queued.clear();
    }

    public void addToast(Toast p_94923_) {
        this.queued.add(p_94923_);
    }

    public Minecraft getMinecraft() {
        return this.minecraft;
    }

    public double getNotificationDisplayTimeMultiplier() {
        return this.minecraft.options.notificationDisplayTime().get();
    }

    class ToastInstance<T extends Toast> {
        private static final long ANIMATION_TIME = 600L;
        private final T toast;
        final int index;
        final int slotCount;
        private long animationTime = -1L;
        private long visibleTime = -1L;
        private Toast.Visibility visibility = Toast.Visibility.SHOW;
        final /* synthetic */ ToastComponent this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        ToastInstance(T p_243319_, int p_243300_, int p_243224_) {
            this.this$0 = (ToastComponent)n;
            this.toast = p_243319_;
            this.index = p_243300_;
            this.slotCount = p_243224_;
        }

        public T getToast() {
            return this.toast;
        }

        private float getVisibility(long p_94948_) {
            float $$1 = Mth.clamp((float)(p_94948_ - this.animationTime) / 600.0f, 0.0f, 1.0f);
            $$1 *= $$1;
            if (this.visibility == Toast.Visibility.HIDE) {
                return 1.0f - $$1;
            }
            return $$1;
        }

        public boolean render(int p_282887_, GuiGraphics p_283668_) {
            long $$2 = Util.getMillis();
            if (this.animationTime == -1L) {
                this.animationTime = $$2;
                this.visibility.playSound(this.this$0.minecraft.getSoundManager());
            }
            if (this.visibility == Toast.Visibility.SHOW && $$2 - this.animationTime <= 600L) {
                this.visibleTime = $$2;
            }
            p_283668_.pose().pushPose();
            p_283668_.pose().translate((float)p_282887_ - (float)this.toast.width() * this.getVisibility($$2), this.index * 32, 800.0f);
            Toast.Visibility $$3 = this.toast.render(p_283668_, this.this$0, $$2 - this.visibleTime);
            p_283668_.pose().popPose();
            if ($$3 != this.visibility) {
                this.animationTime = $$2 - (long)((int)((1.0f - this.getVisibility($$2)) * 600.0f));
                this.visibility = $$3;
                this.visibility.playSound(this.this$0.minecraft.getSoundManager());
            }
            return this.visibility == Toast.Visibility.HIDE && $$2 - this.animationTime > 600L;
        }
    }
}

