/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import java.util.EnumMap;
import net.minecraft.Util;
import net.minecraft.client.gui.components.DebugScreenOverlay;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.protocol.game.ServerboundDebugSampleSubscriptionPacket;
import net.minecraft.util.debugchart.RemoteDebugSampleType;

public class DebugSampleSubscriber {
    public static final int REQUEST_INTERVAL_MS = 5000;
    private final ClientPacketListener connection;
    private final DebugScreenOverlay debugScreenOverlay;
    private final EnumMap<RemoteDebugSampleType, Long> lastRequested;

    public DebugSampleSubscriber(ClientPacketListener p_324284_, DebugScreenOverlay p_324198_) {
        this.debugScreenOverlay = p_324198_;
        this.connection = p_324284_;
        this.lastRequested = new EnumMap(RemoteDebugSampleType.class);
    }

    public void tick() {
        if (this.debugScreenOverlay.showFpsCharts()) {
            this.sendSubscriptionRequestIfNeeded(RemoteDebugSampleType.TICK_TIME);
        }
    }

    private void sendSubscriptionRequestIfNeeded(RemoteDebugSampleType p_324259_) {
        long $$1 = Util.getMillis();
        if ($$1 > this.lastRequested.getOrDefault((Object)p_324259_, 0L) + 5000L) {
            this.connection.send(new ServerboundDebugSampleSubscriptionPacket(p_324259_));
            this.lastRequested.put(p_324259_, $$1);
        }
    }
}

