/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;

public class SimpleAnimatedParticle
extends TextureSheetParticle {
    protected final SpriteSet sprites;
    private float fadeR;
    private float fadeG;
    private float fadeB;
    private boolean hasFade;

    protected SimpleAnimatedParticle(ClientLevel p_107647_, double p_107648_, double p_107649_, double p_107650_, SpriteSet p_107651_, float p_107652_) {
        super(p_107647_, p_107648_, p_107649_, p_107650_);
        this.friction = 0.91f;
        this.gravity = p_107652_;
        this.sprites = p_107651_;
    }

    public void setColor(int p_107658_) {
        float $$1 = (float)((p_107658_ & 0xFF0000) >> 16) / 255.0f;
        float $$2 = (float)((p_107658_ & 0xFF00) >> 8) / 255.0f;
        float $$3 = (float)((p_107658_ & 0xFF) >> 0) / 255.0f;
        float $$4 = 1.0f;
        this.setColor($$1 * 1.0f, $$2 * 1.0f, $$3 * 1.0f);
    }

    public void setFadeColor(int p_107660_) {
        this.fadeR = (float)((p_107660_ & 0xFF0000) >> 16) / 255.0f;
        this.fadeG = (float)((p_107660_ & 0xFF00) >> 8) / 255.0f;
        this.fadeB = (float)((p_107660_ & 0xFF) >> 0) / 255.0f;
        this.hasFade = true;
    }

    @Override
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    @Override
    public void tick() {
        super.tick();
        this.setSpriteFromAge(this.sprites);
        if (this.age > this.lifetime / 2) {
            this.setAlpha(1.0f - ((float)this.age - (float)(this.lifetime / 2)) / (float)this.lifetime);
            if (this.hasFade) {
                this.rCol += (this.fadeR - this.rCol) * 0.2f;
                this.gCol += (this.fadeG - this.gCol) * 0.2f;
                this.bCol += (this.fadeB - this.bCol) * 0.2f;
            }
        }
    }

    @Override
    public int getLightColor(float p_107655_) {
        return 0xF000F0;
    }
}

