/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.chunk;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.client.renderer.chunk.RenderChunkRegion;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;

public class RenderRegionCache {
    private final Long2ObjectMap<ChunkInfo> chunkInfoCache = new Long2ObjectOpenHashMap();

    @Nullable
    public RenderChunkRegion createRegion(Level p_200466_, SectionPos p_350879_) {
        ChunkInfo $$2 = this.getChunkInfo(p_200466_, p_350879_.x(), p_350879_.z());
        if ($$2.chunk().isSectionEmpty(p_350879_.y())) {
            return null;
        }
        int $$3 = p_350879_.x() - 1;
        int $$4 = p_350879_.z() - 1;
        int $$5 = p_350879_.x() + 1;
        int $$6 = p_350879_.z() + 1;
        RenderChunk[] $$7 = new RenderChunk[9];
        for (int $$8 = $$4; $$8 <= $$6; ++$$8) {
            for (int $$9 = $$3; $$9 <= $$5; ++$$9) {
                int $$10 = RenderChunkRegion.index($$3, $$4, $$9, $$8);
                ChunkInfo $$11 = $$9 == p_350879_.x() && $$8 == p_350879_.z() ? $$2 : this.getChunkInfo(p_200466_, $$9, $$8);
                $$7[$$10] = $$11.renderChunk();
            }
        }
        return new RenderChunkRegion(p_200466_, $$3, $$4, $$7);
    }

    private ChunkInfo getChunkInfo(Level p_350834_, int p_350803_, int p_350907_) {
        return (ChunkInfo)this.chunkInfoCache.computeIfAbsent(ChunkPos.asLong(p_350803_, p_350907_), p_200464_ -> new ChunkInfo(p_350834_.getChunk(ChunkPos.getX(p_200464_), ChunkPos.getZ(p_200464_))));
    }

    static final class ChunkInfo {
        private final LevelChunk chunk;
        @Nullable
        private RenderChunk renderChunk;

        ChunkInfo(LevelChunk p_200479_) {
            this.chunk = p_200479_;
        }

        public LevelChunk chunk() {
            return this.chunk;
        }

        public RenderChunk renderChunk() {
            if (this.renderChunk == null) {
                this.renderChunk = new RenderChunk(this.chunk);
            }
            return this.renderChunk;
        }
    }
}

