/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.jarjar.nio;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AbstractPath
implements Path {
    protected AbstractPath() {
    }

    @Override
    public final boolean startsWith(String other) {
        return this.startsWith(this.getFileSystem().getPath(other, new String[0]));
    }

    @Override
    public final boolean endsWith(String other) {
        return this.endsWith(this.getFileSystem().getPath(other, new String[0]));
    }

    @Override
    public final Path resolve(String other) {
        return this.resolve(this.getFileSystem().getPath(other, new String[0]));
    }

    @Override
    public final Path resolveSibling(Path other) {
        if (other == null) {
            throw new NullPointerException();
        }
        Path parent = this.getParent();
        return parent == null ? other : parent.resolve(other);
    }

    @Override
    public final Path resolveSibling(String other) {
        return this.resolveSibling(this.getFileSystem().getPath(other, new String[0]));
    }

    @Override
    public final Iterator<Path> iterator() {
        return new Iterator<Path>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < AbstractPath.this.getNameCount();
            }

            @Override
            public Path next() {
                if (this.i < AbstractPath.this.getNameCount()) {
                    Path result = AbstractPath.this.getName(this.i);
                    ++this.i;
                    return result;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public final File toFile() {
        return new File(this.toString());
    }

    @Override
    public final WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) throws IOException {
        return this.register(watcher, events, new WatchEvent.Modifier[0]);
    }
}

