/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.audio;

import com.mojang.blaze3d.audio.OpenAlUtil;
import com.mojang.blaze3d.audio.SoundBuffer;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import javax.sound.sampled.AudioFormat;
import net.minecraft.client.sounds.AudioStream;
import net.minecraft.world.phys.Vec3;
import org.lwjgl.openal.AL10;
import org.slf4j.Logger;

public class Channel {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int QUEUED_BUFFER_COUNT = 4;
    public static final int BUFFER_DURATION_SECONDS = 1;
    private final int source;
    private final AtomicBoolean initialized = new AtomicBoolean(true);
    private int streamingBufferSize = 16384;
    @Nullable
    private AudioStream stream;

    @Nullable
    static Channel create() {
        int[] $$0 = new int[1];
        AL10.alGenSources((int[])$$0);
        if (OpenAlUtil.checkALError("Allocate new source")) {
            return null;
        }
        return new Channel($$0[0]);
    }

    private Channel(int p_83648_) {
        this.source = p_83648_;
    }

    public void destroy() {
        if (this.initialized.compareAndSet(true, false)) {
            AL10.alSourceStop((int)this.source);
            OpenAlUtil.checkALError("Stop");
            if (this.stream != null) {
                try {
                    this.stream.close();
                }
                catch (IOException $$0) {
                    LOGGER.error("Failed to close audio stream", (Throwable)$$0);
                }
                this.removeProcessedBuffers();
                this.stream = null;
            }
            AL10.alDeleteSources((int[])new int[]{this.source});
            OpenAlUtil.checkALError("Cleanup");
        }
    }

    public void play() {
        AL10.alSourcePlay((int)this.source);
    }

    private int getState() {
        if (!this.initialized.get()) {
            return 4116;
        }
        return AL10.alGetSourcei((int)this.source, (int)4112);
    }

    public void pause() {
        if (this.getState() == 4114) {
            AL10.alSourcePause((int)this.source);
        }
    }

    public void unpause() {
        if (this.getState() == 4115) {
            AL10.alSourcePlay((int)this.source);
        }
    }

    public void stop() {
        if (this.initialized.get()) {
            AL10.alSourceStop((int)this.source);
            OpenAlUtil.checkALError("Stop");
        }
    }

    public boolean playing() {
        return this.getState() == 4114;
    }

    public boolean stopped() {
        return this.getState() == 4116;
    }

    public void setSelfPosition(Vec3 p_83655_) {
        AL10.alSourcefv((int)this.source, (int)4100, (float[])new float[]{(float)p_83655_.x, (float)p_83655_.y, (float)p_83655_.z});
    }

    public void setPitch(float p_83651_) {
        AL10.alSourcef((int)this.source, (int)4099, (float)p_83651_);
    }

    public void setLooping(boolean p_83664_) {
        AL10.alSourcei((int)this.source, (int)4103, (int)(p_83664_ ? 1 : 0));
    }

    public void setVolume(float p_83667_) {
        AL10.alSourcef((int)this.source, (int)4106, (float)p_83667_);
    }

    public void disableAttenuation() {
        AL10.alSourcei((int)this.source, (int)53248, (int)0);
    }

    public void linearAttenuation(float p_83674_) {
        AL10.alSourcei((int)this.source, (int)53248, (int)53251);
        AL10.alSourcef((int)this.source, (int)4131, (float)p_83674_);
        AL10.alSourcef((int)this.source, (int)4129, (float)1.0f);
        AL10.alSourcef((int)this.source, (int)4128, (float)0.0f);
    }

    public void setRelative(boolean p_83671_) {
        AL10.alSourcei((int)this.source, (int)514, (int)(p_83671_ ? 1 : 0));
    }

    public void attachStaticBuffer(SoundBuffer p_83657_) {
        p_83657_.getAlBuffer().ifPresent(p_83676_ -> AL10.alSourcei((int)this.source, (int)4105, (int)p_83676_));
    }

    public void attachBufferStream(AudioStream p_83659_) {
        this.stream = p_83659_;
        AudioFormat $$1 = p_83659_.getFormat();
        this.streamingBufferSize = Channel.calculateBufferSize($$1, 1);
        this.pumpBuffers(4);
    }

    private static int calculateBufferSize(AudioFormat p_83661_, int p_83662_) {
        return (int)((float)(p_83662_ * p_83661_.getSampleSizeInBits()) / 8.0f * (float)p_83661_.getChannels() * p_83661_.getSampleRate());
    }

    private void pumpBuffers(int p_83653_) {
        if (this.stream != null) {
            try {
                for (int $$1 = 0; $$1 < p_83653_; ++$$1) {
                    ByteBuffer $$2 = this.stream.read(this.streamingBufferSize);
                    if ($$2 == null) continue;
                    new SoundBuffer($$2, this.stream.getFormat()).releaseAlBuffer().ifPresent(p_83669_ -> AL10.alSourceQueueBuffers((int)this.source, (int[])new int[]{p_83669_}));
                }
            }
            catch (IOException $$3) {
                LOGGER.error("Failed to read from audio stream", (Throwable)$$3);
            }
        }
    }

    public void updateStream() {
        if (this.stream != null) {
            int $$0 = this.removeProcessedBuffers();
            this.pumpBuffers($$0);
        }
    }

    private int removeProcessedBuffers() {
        int $$0 = AL10.alGetSourcei((int)this.source, (int)4118);
        if ($$0 > 0) {
            int[] $$1 = new int[$$0];
            AL10.alSourceUnqueueBuffers((int)this.source, (int[])$$1);
            OpenAlUtil.checkALError("Unqueue buffers");
            AL10.alDeleteBuffers((int[])$$1);
            OpenAlUtil.checkALError("Remove processed buffers");
        }
        return $$0;
    }
}

