/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity.player;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Objects;
import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.ArrowLayer;
import net.minecraft.client.renderer.entity.layers.BeeStingerLayer;
import net.minecraft.client.renderer.entity.layers.CapeLayer;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.Deadmau5EarsLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ParrotOnShoulderLayer;
import net.minecraft.client.renderer.entity.layers.PlayerItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.SpinAttackEffectLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.numbers.StyledFormat;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.ReadOnlyScoreInfo;
import net.minecraft.world.scores.Scoreboard;

public class PlayerRenderer
extends LivingEntityRenderer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    public PlayerRenderer(EntityRendererProvider.Context p_174557_, boolean p_174558_) {
        super(p_174557_, new PlayerModel(p_174557_.bakeLayer(p_174558_ ? ModelLayers.PLAYER_SLIM : ModelLayers.PLAYER), p_174558_), 0.5f);
        this.addLayer(new HumanoidArmorLayer(this, new HumanoidArmorModel(p_174557_.bakeLayer(p_174558_ ? ModelLayers.PLAYER_SLIM_INNER_ARMOR : ModelLayers.PLAYER_INNER_ARMOR)), new HumanoidArmorModel(p_174557_.bakeLayer(p_174558_ ? ModelLayers.PLAYER_SLIM_OUTER_ARMOR : ModelLayers.PLAYER_OUTER_ARMOR)), p_174557_.getModelManager()));
        this.addLayer(new PlayerItemInHandLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>(this, p_174557_.getItemInHandRenderer()));
        this.addLayer(new ArrowLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>(p_174557_, this));
        this.addLayer(new Deadmau5EarsLayer(this));
        this.addLayer(new CapeLayer(this));
        this.addLayer(new CustomHeadLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>(this, p_174557_.getModelSet(), p_174557_.getItemInHandRenderer()));
        this.addLayer(new ElytraLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>(this, p_174557_.getModelSet()));
        this.addLayer(new ParrotOnShoulderLayer<AbstractClientPlayer>(this, p_174557_.getModelSet()));
        this.addLayer(new SpinAttackEffectLayer<AbstractClientPlayer>(this, p_174557_.getModelSet()));
        this.addLayer(new BeeStingerLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>(this));
    }

    @Override
    public void render(AbstractClientPlayer p_117788_, float p_117789_, float p_117790_, PoseStack p_117791_, MultiBufferSource p_117792_, int p_117793_) {
        this.setModelProperties(p_117788_);
        super.render(p_117788_, p_117789_, p_117790_, p_117791_, p_117792_, p_117793_);
    }

    @Override
    public Vec3 getRenderOffset(AbstractClientPlayer p_117785_, float p_117786_) {
        if (p_117785_.isCrouching()) {
            return new Vec3(0.0, (double)(p_117785_.getScale() * -2.0f) / 16.0, 0.0);
        }
        return super.getRenderOffset(p_117785_, p_117786_);
    }

    private void setModelProperties(AbstractClientPlayer p_117819_) {
        PlayerModel $$1 = (PlayerModel)this.getModel();
        if (p_117819_.isSpectator()) {
            $$1.setAllVisible(false);
            $$1.head.visible = true;
            $$1.hat.visible = true;
        } else {
            $$1.setAllVisible(true);
            $$1.hat.visible = p_117819_.isModelPartShown(PlayerModelPart.HAT);
            $$1.jacket.visible = p_117819_.isModelPartShown(PlayerModelPart.JACKET);
            $$1.leftPants.visible = p_117819_.isModelPartShown(PlayerModelPart.LEFT_PANTS_LEG);
            $$1.rightPants.visible = p_117819_.isModelPartShown(PlayerModelPart.RIGHT_PANTS_LEG);
            $$1.leftSleeve.visible = p_117819_.isModelPartShown(PlayerModelPart.LEFT_SLEEVE);
            $$1.rightSleeve.visible = p_117819_.isModelPartShown(PlayerModelPart.RIGHT_SLEEVE);
            $$1.crouching = p_117819_.isCrouching();
            HumanoidModel.ArmPose $$2 = PlayerRenderer.getArmPose(p_117819_, InteractionHand.MAIN_HAND);
            HumanoidModel.ArmPose $$3 = PlayerRenderer.getArmPose(p_117819_, InteractionHand.OFF_HAND);
            if ($$2.isTwoHanded()) {
                HumanoidModel.ArmPose armPose = $$3 = p_117819_.getOffhandItem().isEmpty() ? HumanoidModel.ArmPose.EMPTY : HumanoidModel.ArmPose.ITEM;
            }
            if (p_117819_.getMainArm() == HumanoidArm.RIGHT) {
                $$1.rightArmPose = $$2;
                $$1.leftArmPose = $$3;
            } else {
                $$1.rightArmPose = $$3;
                $$1.leftArmPose = $$2;
            }
        }
    }

    private static HumanoidModel.ArmPose getArmPose(AbstractClientPlayer p_117795_, InteractionHand p_117796_) {
        ItemStack $$2 = p_117795_.getItemInHand(p_117796_);
        if ($$2.isEmpty()) {
            return HumanoidModel.ArmPose.EMPTY;
        }
        if (p_117795_.getUsedItemHand() == p_117796_ && p_117795_.getUseItemRemainingTicks() > 0) {
            UseAnim $$3 = $$2.getUseAnimation();
            if ($$3 == UseAnim.BLOCK) {
                return HumanoidModel.ArmPose.BLOCK;
            }
            if ($$3 == UseAnim.BOW) {
                return HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
            if ($$3 == UseAnim.SPEAR) {
                return HumanoidModel.ArmPose.THROW_SPEAR;
            }
            if ($$3 == UseAnim.CROSSBOW && p_117796_ == p_117795_.getUsedItemHand()) {
                return HumanoidModel.ArmPose.CROSSBOW_CHARGE;
            }
            if ($$3 == UseAnim.SPYGLASS) {
                return HumanoidModel.ArmPose.SPYGLASS;
            }
            if ($$3 == UseAnim.TOOT_HORN) {
                return HumanoidModel.ArmPose.TOOT_HORN;
            }
            if ($$3 == UseAnim.BRUSH) {
                return HumanoidModel.ArmPose.BRUSH;
            }
        } else if (!p_117795_.swinging && $$2.is(Items.CROSSBOW) && CrossbowItem.isCharged($$2)) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        return HumanoidModel.ArmPose.ITEM;
    }

    @Override
    public ResourceLocation getTextureLocation(AbstractClientPlayer p_117783_) {
        return p_117783_.getSkin().texture();
    }

    @Override
    protected void scale(AbstractClientPlayer p_117798_, PoseStack p_117799_, float p_117800_) {
        float $$3 = 0.9375f;
        p_117799_.scale(0.9375f, 0.9375f, 0.9375f);
    }

    @Override
    protected void renderNameTag(AbstractClientPlayer p_117808_, Component p_117809_, PoseStack p_117810_, MultiBufferSource p_117811_, int p_117812_, float p_316461_) {
        Scoreboard $$7;
        Objective $$8;
        double $$6 = this.entityRenderDispatcher.distanceToSqr(p_117808_);
        p_117810_.pushPose();
        if ($$6 < 100.0 && ($$8 = ($$7 = p_117808_.getScoreboard()).getDisplayObjective(DisplaySlot.BELOW_NAME)) != null) {
            ReadOnlyScoreInfo $$9 = $$7.getPlayerScoreInfo(p_117808_, $$8);
            MutableComponent $$10 = ReadOnlyScoreInfo.safeFormatValue($$9, $$8.numberFormatOrDefault(StyledFormat.NO_STYLE));
            super.renderNameTag(p_117808_, Component.empty().append($$10).append(CommonComponents.SPACE).append($$8.getDisplayName()), p_117810_, p_117811_, p_117812_, p_316461_);
            Objects.requireNonNull(this.getFont());
            p_117810_.translate(0.0f, 9.0f * 1.15f * 0.025f, 0.0f);
        }
        super.renderNameTag(p_117808_, p_117809_, p_117810_, p_117811_, p_117812_, p_316461_);
        p_117810_.popPose();
    }

    public void renderRightHand(PoseStack p_117771_, MultiBufferSource p_117772_, int p_117773_, AbstractClientPlayer p_117774_) {
        this.renderHand(p_117771_, p_117772_, p_117773_, p_117774_, ((PlayerModel)this.model).rightArm, ((PlayerModel)this.model).rightSleeve);
    }

    public void renderLeftHand(PoseStack p_117814_, MultiBufferSource p_117815_, int p_117816_, AbstractClientPlayer p_117817_) {
        this.renderHand(p_117814_, p_117815_, p_117816_, p_117817_, ((PlayerModel)this.model).leftArm, ((PlayerModel)this.model).leftSleeve);
    }

    private void renderHand(PoseStack p_117776_, MultiBufferSource p_117777_, int p_117778_, AbstractClientPlayer p_117779_, ModelPart p_117780_, ModelPart p_117781_) {
        PlayerModel $$6 = (PlayerModel)this.getModel();
        this.setModelProperties(p_117779_);
        $$6.attackTime = 0.0f;
        $$6.crouching = false;
        $$6.swimAmount = 0.0f;
        $$6.setupAnim(p_117779_, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        p_117780_.xRot = 0.0f;
        ResourceLocation $$7 = p_117779_.getSkin().texture();
        p_117780_.render(p_117776_, p_117777_.getBuffer(RenderType.entitySolid($$7)), p_117778_, OverlayTexture.NO_OVERLAY);
        p_117781_.xRot = 0.0f;
        p_117781_.render(p_117776_, p_117777_.getBuffer(RenderType.entityTranslucent($$7)), p_117778_, OverlayTexture.NO_OVERLAY);
    }

    @Override
    protected void setupRotations(AbstractClientPlayer p_117802_, PoseStack p_117803_, float p_117804_, float p_117805_, float p_117806_, float p_320048_) {
        float $$6 = p_117802_.getSwimAmount(p_117806_);
        float $$7 = p_117802_.getViewXRot(p_117806_);
        if (p_117802_.isFallFlying()) {
            super.setupRotations(p_117802_, p_117803_, p_117804_, p_117805_, p_117806_, p_320048_);
            float $$8 = (float)p_117802_.getFallFlyingTicks() + p_117806_;
            float $$9 = Mth.clamp($$8 * $$8 / 100.0f, 0.0f, 1.0f);
            if (!p_117802_.isAutoSpinAttack()) {
                p_117803_.mulPose(Axis.XP.rotationDegrees($$9 * (-90.0f - $$7)));
            }
            Vec3 $$10 = p_117802_.getViewVector(p_117806_);
            Vec3 $$11 = p_117802_.getDeltaMovementLerped(p_117806_);
            double $$12 = $$11.horizontalDistanceSqr();
            double $$13 = $$10.horizontalDistanceSqr();
            if ($$12 > 0.0 && $$13 > 0.0) {
                double $$14 = ($$11.x * $$10.x + $$11.z * $$10.z) / Math.sqrt($$12 * $$13);
                double $$15 = $$11.x * $$10.z - $$11.z * $$10.x;
                p_117803_.mulPose(Axis.YP.rotation((float)(Math.signum($$15) * Math.acos($$14))));
            }
        } else if ($$6 > 0.0f) {
            super.setupRotations(p_117802_, p_117803_, p_117804_, p_117805_, p_117806_, p_320048_);
            float $$16 = p_117802_.isInWater() ? -90.0f - $$7 : -90.0f;
            float $$17 = Mth.lerp($$6, 0.0f, $$16);
            p_117803_.mulPose(Axis.XP.rotationDegrees($$17));
            if (p_117802_.isVisuallySwimming()) {
                p_117803_.translate(0.0f, -1.0f, 0.3f);
            }
        } else {
            super.setupRotations(p_117802_, p_117803_, p_117804_, p_117805_, p_117806_, p_320048_);
        }
    }
}

