/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.language;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.resources.language.ClientLanguage;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.language.LanguageInfo;
import net.minecraft.client.resources.metadata.language.LanguageMetadataSection;
import net.minecraft.locale.Language;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import org.slf4j.Logger;

public class LanguageManager
implements ResourceManagerReloadListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final LanguageInfo DEFAULT_LANGUAGE = new LanguageInfo("US", "English", false);
    private Map<String, LanguageInfo> languages = ImmutableMap.of((Object)"en_us", (Object)DEFAULT_LANGUAGE);
    private String currentCode;
    private final Consumer<ClientLanguage> reloadCallback;

    public LanguageManager(String p_118971_, Consumer<ClientLanguage> p_345582_) {
        this.currentCode = p_118971_;
        this.reloadCallback = p_345582_;
    }

    private static Map<String, LanguageInfo> extractLanguages(Stream<PackResources> p_118982_) {
        HashMap $$1 = Maps.newHashMap();
        p_118982_.forEach(p_264712_ -> {
            try {
                LanguageMetadataSection $$2 = p_264712_.getMetadataSection(LanguageMetadataSection.TYPE);
                if ($$2 != null) {
                    $$2.languages().forEach($$1::putIfAbsent);
                }
            }
            catch (IOException | RuntimeException $$3) {
                LOGGER.warn("Unable to parse language metadata section of resourcepack: {}", (Object)p_264712_.packId(), (Object)$$3);
            }
        });
        return ImmutableMap.copyOf((Map)$$1);
    }

    @Override
    public void onResourceManagerReload(ResourceManager p_118973_) {
        LanguageInfo $$3;
        this.languages = LanguageManager.extractLanguages(p_118973_.listPacks());
        ArrayList<String> $$1 = new ArrayList<String>(2);
        boolean $$2 = DEFAULT_LANGUAGE.bidirectional();
        $$1.add("en_us");
        if (!this.currentCode.equals("en_us") && ($$3 = this.languages.get(this.currentCode)) != null) {
            $$1.add(this.currentCode);
            $$2 = $$3.bidirectional();
        }
        ClientLanguage $$4 = ClientLanguage.loadFrom(p_118973_, $$1, $$2);
        I18n.setLanguage($$4);
        Language.inject($$4);
        this.reloadCallback.accept($$4);
    }

    public void setSelected(String p_265224_) {
        this.currentCode = p_265224_;
    }

    public String getSelected() {
        return this.currentCode;
    }

    public SortedMap<String, LanguageInfo> getLanguages() {
        return new TreeMap<String, LanguageInfo>(this.languages);
    }

    @Nullable
    public LanguageInfo getLanguage(String p_118977_) {
        return this.languages.get(p_118977_);
    }
}

