/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforgespi.locating;

import cpw.mods.jarhandling.SecureJar;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.neoforged.fml.loading.moddiscovery.ModFile;
import net.neoforged.neoforgespi.language.IModFileInfo;
import net.neoforged.neoforgespi.language.IModInfo;
import net.neoforged.neoforgespi.language.ModFileScanData;
import net.neoforged.neoforgespi.locating.InvalidModFileException;
import net.neoforged.neoforgespi.locating.ModFileDiscoveryAttributes;
import net.neoforged.neoforgespi.locating.ModFileInfoParser;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.NonExtendable
public interface IModFile {
    public static IModFile create(SecureJar jar, ModFileInfoParser parser) throws InvalidModFileException {
        return new ModFile(jar, parser, ModFileDiscoveryAttributes.DEFAULT);
    }

    public static IModFile create(SecureJar jar, ModFileInfoParser parser, ModFileDiscoveryAttributes attributes) throws InvalidModFileException {
        return new ModFile(jar, parser, attributes);
    }

    public static IModFile create(SecureJar jar, ModFileInfoParser parser, Type type, ModFileDiscoveryAttributes attributes) throws InvalidModFileException {
        return new ModFile(jar, parser, type, attributes);
    }

    public Path findResource(String ... var1);

    public Supplier<Map<String, Object>> getSubstitutionMap();

    public Type getType();

    public Path getFilePath();

    public SecureJar getSecureJar();

    public void setSecurityStatus(SecureJar.Status var1);

    public List<IModInfo> getModInfos();

    public ModFileScanData getScanResult();

    public String getFileName();

    public ModFileDiscoveryAttributes getDiscoveryAttributes();

    public IModFileInfo getModFileInfo();

    public static enum Type {
        MOD,
        LIBRARY,
        GAMELIBRARY;

    }
}

