/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.registries;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.Reader;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagKey;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.conditions.ConditionalOps;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.WithConditions;
import net.neoforged.neoforge.registries.BaseMappedRegistry;
import net.neoforged.neoforge.registries.RegistryManager;
import net.neoforged.neoforge.registries.datamaps.AdvancedDataMapType;
import net.neoforged.neoforge.registries.datamaps.DataMapEntry;
import net.neoforged.neoforge.registries.datamaps.DataMapFile;
import net.neoforged.neoforge.registries.datamaps.DataMapType;
import net.neoforged.neoforge.registries.datamaps.DataMapValueMerger;
import net.neoforged.neoforge.registries.datamaps.DataMapValueRemover;
import net.neoforged.neoforge.registries.datamaps.DataMapsUpdatedEvent;
import org.slf4j.Logger;

public class DataMapLoader
implements PreparableReloadListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String PATH = "data_maps";
    private Map<ResourceKey<? extends Registry<?>>, LoadResult<?>> results;
    private final ICondition.IContext conditionContext;
    private final RegistryAccess registryAccess;

    public DataMapLoader(ICondition.IContext conditionContext, RegistryAccess registryAccess) {
        this.conditionContext = conditionContext;
        this.registryAccess = registryAccess;
    }

    public CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier preparationBarrier, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        return ((CompletableFuture)this.load(resourceManager, backgroundExecutor, preparationsProfiler).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)preparationBarrier).wait(arg_0))).thenAcceptAsync(values -> {
            this.results = values;
        }, gameExecutor);
    }

    public void apply() {
        this.results.forEach((key, result) -> this.apply((BaseMappedRegistry)this.registryAccess.registryOrThrow(key), (LoadResult)result));
        this.results = null;
    }

    private <T> void apply(BaseMappedRegistry<T> registry, LoadResult<T> result) {
        registry.dataMaps.clear();
        result.results().forEach((key, entries) -> registry.dataMaps.put(key, this.buildDataMap(registry, (DataMapType)key, (List)entries)));
        NeoForge.EVENT_BUS.post((Event)new DataMapsUpdatedEvent(this.registryAccess, registry, DataMapsUpdatedEvent.UpdateCause.SERVER_RELOAD));
    }

    private <T, R> Map<ResourceKey<R>, T> buildDataMap(Registry<R> registry, DataMapType<R, T> attachment, List<DataMapFile<T, R>> entries) {
        DataMapValueMerger dataMapValueMerger;
        record WithSource<T, R>(T attachment, Either<TagKey<R>, ResourceKey<R>> source) {
        }
        IdentityHashMap<ResourceKey, WithSource> result = new IdentityHashMap<ResourceKey, WithSource>();
        if (attachment instanceof AdvancedDataMapType) {
            AdvancedDataMapType adv = (AdvancedDataMapType)attachment;
            dataMapValueMerger = adv.merger();
        } else {
            dataMapValueMerger = DataMapValueMerger.defaultMerger();
        }
        DataMapValueMerger merger = dataMapValueMerger;
        entries.forEach(entry -> {
            if (entry.replace()) {
                result.clear();
            }
            entry.values().forEach((tKey, value) -> {
                if (value.isEmpty()) {
                    return;
                }
                this.resolve(registry, (Either)tKey, true, holder -> {
                    DataMapEntry newValue = (DataMapEntry)((WithConditions)value.get()).carrier();
                    ResourceKey key = holder.getKey();
                    WithSource oldValue = (WithSource)result.get(key);
                    if (oldValue == null || newValue.replace()) {
                        result.put(key, new WithSource(newValue.value(), tKey));
                    } else {
                        result.put(key, new WithSource(merger.merge(registry, oldValue.source(), oldValue.attachment(), tKey, newValue.value()), tKey));
                    }
                });
            });
            for (DataMapEntry.Removal removal : entry.removals()) {
                if (removal.remover().isPresent()) {
                    DataMapValueRemover remover = removal.remover().orElseThrow();
                    this.resolve(registry, removal.key(), false, holder -> {
                        ResourceKey key = holder.getKey();
                        WithSource oldValue = (WithSource)result.get(key);
                        if (oldValue != null) {
                            Optional newValue = remover.remove(oldValue.attachment(), registry, oldValue.source(), holder.value());
                            if (newValue.isEmpty()) {
                                result.remove(key);
                            } else {
                                result.put(key, new WithSource(newValue.get(), oldValue.source()));
                            }
                        }
                    });
                    continue;
                }
                this.resolve(registry, removal.key(), false, holder -> result.remove(holder.getKey()));
            }
        });
        IdentityHashMap newMap = new IdentityHashMap();
        result.forEach((key, val) -> newMap.put(key, val.attachment()));
        return newMap;
    }

    private <R> void resolve(Registry<R> registry, Either<TagKey<R>, ResourceKey<R>> value, boolean required, Consumer<Holder<R>> consumer) {
        if (value.left().isPresent()) {
            registry.getTagOrEmpty((TagKey)value.left().orElseThrow()).forEach(consumer);
        } else {
            Optional object = registry.getHolder((ResourceKey)value.right().orElseThrow());
            if (object.isPresent()) {
                consumer.accept((Holder)object.get());
            } else if (required) {
                LOGGER.error("Object with ID {} specified in data map for registry {} doesn't exist", (Object)((ResourceKey)value.right().orElseThrow()).location(), (Object)registry.key().location());
            }
        }
    }

    private CompletableFuture<Map<ResourceKey<? extends Registry<?>>, LoadResult<?>>> load(ResourceManager manager, Executor executor, ProfilerFiller profiler) {
        return CompletableFuture.supplyAsync(() -> DataMapLoader.load(manager, profiler, this.registryAccess, this.conditionContext), executor);
    }

    private static Map<ResourceKey<? extends Registry<?>>, LoadResult<?>> load(ResourceManager manager, ProfilerFiller profiler, RegistryAccess access, ICondition.IContext context) {
        ConditionalOps ops = new ConditionalOps(RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)access), context);
        HashMap values = new HashMap();
        access.registries().forEach(registryEntry -> {
            ResourceKey registryKey = registryEntry.key();
            profiler.push("registry_data_maps/" + String.valueOf(registryKey.location()) + "/locating");
            FileToIdConverter fileToId = FileToIdConverter.json((String)("data_maps/" + DataMapLoader.getFolderLocation(registryKey.location())));
            for (Map.Entry entry : fileToId.listMatchingResourceStacks(manager).entrySet()) {
                ResourceLocation key = (ResourceLocation)entry.getKey();
                ResourceLocation attachmentId = fileToId.fileToId(key);
                DataMapType attachment = RegistryManager.getDataMap(registryKey, attachmentId);
                if (attachment == null) {
                    LOGGER.warn("Found data map file for non-existent data map type '{}' on registry '{}'.", (Object)attachmentId, (Object)registryKey.location());
                    continue;
                }
                profiler.popPush("registry_data_maps/" + String.valueOf(registryKey.location()) + "/" + String.valueOf(attachmentId) + "/loading");
                values.computeIfAbsent(registryKey, (Function<ResourceKey, LoadResult>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$load$10(net.minecraft.resources.ResourceKey ), (Lnet/minecraft/resources/ResourceKey;)Lnet/neoforged/neoforge/registries/DataMapLoader$LoadResult;)()).results.put(attachment, DataMapLoader.readData(ops, attachment, registryKey, (List)entry.getValue()));
            }
            profiler.pop();
        });
        return values;
    }

    public static String getFolderLocation(ResourceLocation registryId) {
        return (String)(registryId.getNamespace().equals("minecraft") ? "" : registryId.getNamespace() + "/") + registryId.getPath();
    }

    private static <A, T> List<DataMapFile<A, T>> readData(RegistryOps<JsonElement> ops, DataMapType<T, A> attachmentType, ResourceKey<Registry<T>> registryKey, List<Resource> resources) {
        Codec<DataMapFile<A, T>> codec = DataMapFile.codec(registryKey, attachmentType);
        LinkedList<DataMapFile<A, T>> entries = new LinkedList<DataMapFile<A, T>>();
        for (Resource resource : resources) {
            try {
                BufferedReader reader = resource.openAsReader();
                try {
                    JsonElement jsonelement = JsonParser.parseReader((Reader)reader);
                    entries.add((DataMapFile)((Pair)codec.decode(ops, (Object)jsonelement).getOrThrow()).getFirst());
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (Exception exception) {
                LOGGER.error("Could not read data map of type {} for registry {}", new Object[]{attachmentType.id(), registryKey, exception});
            }
        }
        return entries;
    }

    private static /* synthetic */ LoadResult lambda$load$10(ResourceKey k) {
        return new LoadResult(new HashMap());
    }

    private record LoadResult<T>(Map<DataMapType<T, ?>, List<DataMapFile<?, T>>> results) {
    }
}

