/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.ae2addonlib.api;

import appeng.api.config.Actionable;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.GenericStack;
import appeng.helpers.externalstorage.GenericStackInv;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.network.PacketDistributor;
import net.pedroksl.ae2addonlib.network.clientPacket.FluidTankClientAudioPacket;

public interface IFluidTankHandler {
    public ServerPlayer getServerPlayer();

    public ItemStack getCarriedItem();

    public void setCarriedItem(ItemStack var1);

    public GenericStackInv getTank();

    public boolean canExtractFromTank(int var1);

    public boolean canInsertInto(int var1);

    default public void onItemUse(int index, int button) {
        IFluidHandlerItem cap;
        ItemStack stack = this.getCarriedItem();
        if (!stack.isEmpty() && (cap = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM)) != null) {
            GenericStackInv tank = this.getTank();
            if (tank == null) {
                return;
            }
            boolean isBucket = stack.getItem() instanceof BucketItem;
            if (!isBucket && button == 0 || isBucket && ((BucketItem)stack.getItem()).content == Fluids.EMPTY) {
                if (!this.canExtractFromTank(index)) {
                    return;
                }
                GenericStack genStack = tank.getStack(index);
                if (genStack != null && genStack.what() != null) {
                    FluidStack fluid = ((AEFluidKey)genStack.what()).toStack((int)genStack.amount());
                    long extracted = Math.min(genStack.amount(), 1000L);
                    int inserted = cap.fill(new FluidStack(fluid.getFluid(), (int)extracted), IFluidHandler.FluidAction.EXECUTE);
                    long endAmount = genStack.amount() - (long)inserted;
                    if (endAmount > 0L) {
                        tank.setStack(index, new GenericStack(genStack.what(), genStack.amount() - (long)inserted));
                    } else {
                        tank.setStack(index, null);
                    }
                    this.setCarriedItem(cap.getContainer());
                    if (inserted > 0) {
                        PacketDistributor.sendToPlayer((ServerPlayer)this.getServerPlayer(), (CustomPacketPayload)new FluidTankClientAudioPacket(true), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                }
            } else {
                if (!this.canInsertInto(index) || cap.getFluidInTank(0).isEmpty()) {
                    return;
                }
                FluidStack fluid = cap.getFluidInTank(0);
                GenericStack genStack = GenericStack.fromFluidStack((FluidStack)fluid);
                if (genStack != null && genStack.what() != null && !cap.drain((int)tank.insert(index, genStack.what(), 1000L, Actionable.SIMULATE), IFluidHandler.FluidAction.SIMULATE).isEmpty()) {
                    long inserted;
                    int extracted = cap.drain(1000, IFluidHandler.FluidAction.EXECUTE).getAmount();
                    if ((long)extracted - (inserted = tank.insert(index, genStack.what(), (long)extracted, Actionable.MODULATE)) > 0L) {
                        cap.fill(new FluidStack(fluid.getFluid(), (int)((long)extracted - inserted)), IFluidHandler.FluidAction.EXECUTE);
                    }
                    this.setCarriedItem(cap.getContainer());
                    PacketDistributor.sendToPlayer((ServerPlayer)this.getServerPlayer(), (CustomPacketPayload)new FluidTankClientAudioPacket(true), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }
}

