/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.ae2addonlib.api;

import appeng.api.config.Setting;
import com.google.common.base.Preconditions;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class SettingsRegistry {
    private static final Map<String, Map<String, Setting<?>>> SETTINGS_MAP = new HashMap();

    protected static synchronized <T extends Enum<T>> Setting<T> register(String modId, String name, Class<T> enumClass) {
        Preconditions.checkState((!SettingsRegistry.getSettings(modId).containsKey(name) ? 1 : 0) != 0);
        Setting setting = new Setting(name, enumClass);
        SETTINGS_MAP.get(modId).put(name, setting);
        return setting;
    }

    @SafeVarargs
    protected static synchronized <T extends Enum<T>> Setting<T> register(String modId, String name, T firstOption, T ... moreOptions) {
        Preconditions.checkState((!SettingsRegistry.getSettings(modId).containsKey(name) ? 1 : 0) != 0);
        Setting setting = new Setting(name, firstOption.getDeclaringClass(), EnumSet.of(firstOption, moreOptions));
        SETTINGS_MAP.get(modId).put(name, setting);
        return setting;
    }

    public static Setting<?> getOrThrow(String modId, @NotNull String name) {
        Setting<?> setting = SettingsRegistry.getSettings(modId).get(name);
        if (setting == null) {
            throw new IllegalArgumentException("Unknown setting '" + name + "'");
        }
        return setting;
    }

    private static Map<String, Setting<?>> getSettings(String modId) {
        if (!SETTINGS_MAP.containsKey(modId)) {
            SETTINGS_MAP.put(modId, new HashMap());
        }
        return SETTINGS_MAP.get(modId);
    }
}

