/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.ae2addonlib.client;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.PacketDistributor;
import net.pedroksl.ae2addonlib.network.serverPacket.AddonHotkeyPacket;
import net.pedroksl.ae2addonlib.registry.HotkeyRegistry;
import org.jetbrains.annotations.Nullable;

public class Hotkeys {
    private static final Map<String, AddonHotkey> HOTKEYS = new HashMap<String, AddonHotkey>();
    private final String modId;
    private boolean finalized;

    public Hotkeys(String modId) {
        this.modId = modId;
    }

    private AddonHotkey createHotkey(String id) {
        int defaultHotkey = this.getDefaultHotkey(id);
        if (this.finalized) {
            throw new IllegalStateException("Hotkey registration already finalized!");
        }
        return new AddonHotkey(this.modId, id, new KeyMapping("key." + this.modId + "." + id, defaultHotkey, "key." + this.modId + ".category"));
    }

    private void registerHotkey(AddonHotkey hotkey) {
        HOTKEYS.put(hotkey.name(), hotkey);
    }

    public void finalizeRegistration(Consumer<KeyMapping> register) {
        for (AddonHotkey value : HOTKEYS.values()) {
            register.accept(value.mapping());
        }
        this.finalized = true;
    }

    public void registerHotkey(String id) {
        this.registerHotkey(this.createHotkey(id));
    }

    public void checkHotkeys() {
        HOTKEYS.forEach((name, hotkey) -> hotkey.check());
    }

    @Nullable
    public AddonHotkey getHotkeyMapping(@Nullable String id) {
        return HOTKEYS.get(id);
    }

    private int getDefaultHotkey(String id) {
        return HotkeyRegistry.getDefaultHotkey(this.modId, id);
    }

    public record AddonHotkey(String modId, String name, KeyMapping mapping) {
        public void check() {
            while (this.mapping().consumeClick()) {
                AddonHotkeyPacket message = new AddonHotkeyPacket(this);
                PacketDistributor.sendToServer((CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }
}

