/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.ae2addonlib.client.widgets;

import appeng.api.config.Setting;
import appeng.client.gui.AEBaseScreen;
import appeng.core.localization.ButtonToolTips;
import appeng.core.localization.LocalizationEnum;
import appeng.util.EnumCycler;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.network.PacketDistributor;
import net.pedroksl.ae2addonlib.client.widgets.AddonIconButton;
import net.pedroksl.ae2addonlib.client.widgets.IBlitterIcon;
import net.pedroksl.ae2addonlib.client.widgets.LibIcons;
import net.pedroksl.ae2addonlib.network.serverPacket.AddonConfigButtonPacket;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class AddonSettingToggleButton<T extends Enum<T>>
extends AddonIconButton {
    private static final Logger LOG = LogUtils.getLogger();
    private static final Map<EnumPair<?>, ButtonAppearance> APPEARANCES = new HashMap();
    private final Setting<T> buttonSetting;
    private final IHandler<AddonSettingToggleButton<T>> onPress;
    private final EnumSet<T> validValues;
    private T currentValue;

    public AddonSettingToggleButton(Setting<T> setting, T val, IHandler<AddonSettingToggleButton<T>> onPress) {
        this((Setting<Enum>)setting, (Enum)val, t -> true, (IHandler<AddonSettingToggleButton<Enum>>)onPress);
    }

    public AddonSettingToggleButton(Setting<T> setting, T val, Predicate<T> isValidValue, IHandler<AddonSettingToggleButton<T>> onPress) {
        super(AddonSettingToggleButton::onPress);
        this.onPress = onPress;
        EnumSet<Object> validValues = EnumSet.allOf(((Enum)val).getDeclaringClass());
        validValues.removeIf(isValidValue.negate());
        validValues.removeIf(s -> !setting.getValues().contains(s));
        this.validValues = validValues;
        this.buttonSetting = setting;
        this.currentValue = val;
        EnumPair<T> key = new EnumPair<T>(setting, val);
        if (!APPEARANCES.containsKey(key)) {
            this.registerAppearances();
            if (!APPEARANCES.containsKey(key)) {
                LOG.error("Tried to initialize button with invalid setting: {}", (Object)setting.getName());
                throw new IllegalArgumentException();
            }
        }
    }

    public static <T extends Enum<T>, M extends AddonSettingToggleButton<T>> M serverButton(Setting<T> setting, T val, String modId, ServerSettingToggleFactory<M, T> factory) {
        return (M)((Object)((AddonSettingToggleButton)((Object)factory.create(setting, val, t -> true, (button, backwards) -> AddonSettingToggleButton.sendToServer(button, backwards, modId)))));
    }

    protected void registerAppearances() {
    }

    private static void onPress(Button btn) {
        if (btn instanceof AddonSettingToggleButton) {
            ((AddonSettingToggleButton)btn).triggerPress();
        }
    }

    private void triggerPress() {
        boolean backwards = false;
        Screen currentScreen = Minecraft.getInstance().screen;
        if (currentScreen instanceof AEBaseScreen) {
            backwards = ((AEBaseScreen)currentScreen).isHandlingRightClick();
        }
        this.onPress.handle(this, backwards);
    }

    protected static <T extends Enum<T>> void registerApp(IBlitterIcon icon, Setting<T> setting, T val, LocalizationEnum title, Component ... tooltipLines) {
        ArrayList<Component> lines = new ArrayList<Component>();
        lines.add((Component)title.text());
        Collections.addAll(lines, tooltipLines);
        APPEARANCES.put(new EnumPair<T>(setting, val), new ButtonAppearance(icon, null, lines));
    }

    protected static <T extends Enum<T>> void registerApp(ItemLike item, Setting<T> setting, T val, LocalizationEnum title, Component ... tooltipLines) {
        ArrayList<Component> lines = new ArrayList<Component>();
        lines.add((Component)title.text());
        Collections.addAll(lines, tooltipLines);
        APPEARANCES.put(new EnumPair<T>(setting, val), new ButtonAppearance(null, item.asItem(), lines));
    }

    protected static <T extends Enum<T>> void registerApp(IBlitterIcon icon, Setting<T> setting, T val, LocalizationEnum title, LocalizationEnum hint) {
        AddonSettingToggleButton.registerApp(icon, setting, val, title, new Component[]{hint.text()});
    }

    @Nullable
    private ButtonAppearance getAppearance() {
        if (this.buttonSetting != null && this.currentValue != null) {
            return APPEARANCES.get(new EnumPair<T>(this.buttonSetting, this.currentValue));
        }
        return null;
    }

    @Override
    protected IBlitterIcon getIcon() {
        ButtonAppearance app = this.getAppearance();
        if (app != null && app.icon != null) {
            return app.icon;
        }
        return LibIcons.TOOLBAR_BUTTON_BACKGROUND;
    }

    @Override
    protected Item getItemOverlay() {
        ButtonAppearance app = this.getAppearance();
        if (app != null && app.item != null) {
            return app.item;
        }
        return null;
    }

    public Setting<T> getSetting() {
        return this.buttonSetting;
    }

    public T getCurrentValue() {
        return this.currentValue;
    }

    public void set(T e) {
        if (this.currentValue != e) {
            this.currentValue = e;
        }
    }

    public T getNextValue(boolean backwards) {
        return (T)EnumCycler.rotateEnum(this.currentValue, (boolean)backwards, this.validValues);
    }

    @Override
    public List<Component> getTooltipMessage() {
        if (this.buttonSetting == null || this.currentValue == null) {
            return Collections.emptyList();
        }
        ButtonAppearance buttonAppearance = APPEARANCES.get(new EnumPair<T>(this.buttonSetting, this.currentValue));
        if (buttonAppearance == null) {
            return Collections.singletonList(ButtonToolTips.NoSuchMessage.text());
        }
        return buttonAppearance.tooltipLines;
    }

    private static <T extends Enum<T>> void sendToServer(AddonSettingToggleButton<T> button, boolean backwards, String modId) {
        AddonConfigButtonPacket message = new AddonConfigButtonPacket(modId, button.getSetting(), backwards);
        PacketDistributor.sendToServer((CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @FunctionalInterface
    public static interface IHandler<T extends AddonSettingToggleButton<?>> {
        public void handle(T var1, boolean var2);
    }

    protected static final class EnumPair<T extends Enum<T>> {
        final Setting<T> setting;
        final T value;

        public EnumPair(Setting<T> setting, T value) {
            this.setting = setting;
            this.value = value;
        }

        public int hashCode() {
            return this.setting.hashCode() ^ ((Enum)this.value).hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EnumPair other = (EnumPair)obj;
            return other.setting == this.setting && other.value == this.value;
        }
    }

    @FunctionalInterface
    public static interface ServerSettingToggleFactory<C, T extends Enum<T>> {
        public C create(Setting<T> var1, T var2, Predicate<T> var3, IHandler<AddonSettingToggleButton<T>> var4);
    }

    protected record ButtonAppearance(@Nullable IBlitterIcon icon, @Nullable Item item, List<Component> tooltipLines) {
    }
}

