/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.ae2addonlib.client.widgets;

import appeng.client.Point;
import appeng.client.gui.ICompositeWidget;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.pedroksl.ae2addonlib.util.Colors;
import org.joml.Matrix4f;

public class SaturationValuePicker
implements ICompositeWidget {
    private Point position;
    private int width;
    private int height;
    private float hue;
    private float saturation;
    private float value;
    private final BiConsumer<Float, Float> saturationAndValueSetter;
    private boolean isDragging = false;

    public SaturationValuePicker(float hue, float saturation, float value, BiConsumer<Float, Float> saturationAndValueSetter) {
        this.hue = hue;
        this.saturation = saturation;
        this.value = value;
        this.saturationAndValueSetter = saturationAndValueSetter;
    }

    public void drawBackgroundLayer(GuiGraphics guiGraphics, Rect2i bounds, Point mouse) {
        int minX = bounds.getX() + this.position.getX();
        int minY = bounds.getY() + this.position.getY();
        int w = this.width;
        int h = this.height;
        int lineColor = -12501164;
        guiGraphics.fill(minX - 1, minY - 1, minX + w + 1, minY + h + 1, lineColor);
        this.renderGradient(guiGraphics, minX, minY, w, h, Colors.ofHsv(this.hue, 0.0f, 1.0f).argb(), Colors.ofHsv(this.hue, 1.0f, 1.0f).argb(), Colors.ofHsv(this.hue, 0.0f, 0.0f).argb(), Colors.ofHsv(this.hue, 1.0f, 0.0f).argb());
        int hsvX = minX + (int)(this.saturation * (float)(this.width - 1));
        int hsvY = minY + (int)((1.0f - this.value) * (float)(this.height - 1));
        guiGraphics.hLine(hsvX - 1, hsvX + 1, hsvY - 1, Color.WHITE.getRGB());
        guiGraphics.hLine(hsvX - 1, hsvX + 1, hsvY + 1, Color.WHITE.getRGB());
        guiGraphics.vLine(hsvX - 1, hsvY - 1, hsvY + 1, Color.WHITE.getRGB());
        guiGraphics.vLine(hsvX + 1, hsvY - 1, hsvY + 1, Color.WHITE.getRGB());
    }

    private void renderGradient(GuiGraphics guiGraphics, int x, int y, int width, int height, int tlColor, int trColor, int blColor, int brColor) {
        RenderType type = RenderType.gui();
        VertexConsumer buffer = guiGraphics.bufferSource().getBuffer(type);
        Matrix4f matrix = guiGraphics.pose().last().pose();
        buffer.addVertex(matrix, (float)(x + width), (float)y, 0.0f).setColor(trColor);
        buffer.addVertex(matrix, (float)x, (float)y, 0.0f).setColor(tlColor);
        buffer.addVertex(matrix, (float)x, (float)(y + height), 0.0f).setColor(blColor);
        buffer.addVertex(matrix, (float)(x + width), (float)(y + height), 0.0f).setColor(brColor);
    }

    public boolean onMouseDown(Point mousePos, int button) {
        if (button != 0) {
            return false;
        }
        this.isDragging = true;
        this.playDownSound();
        this.setValueFromMouse(mousePos.getX(), mousePos.getY());
        return true;
    }

    private void playDownSound() {
        SoundManager handler = Minecraft.getInstance().getSoundManager();
        handler.play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
    }

    public boolean onMouseUp(Point mousePos, int button) {
        this.isDragging = false;
        return false;
    }

    public boolean wantsAllMouseUpEvents() {
        return true;
    }

    public boolean onMouseDrag(Point mousePos, int button) {
        if (this.isDragging) {
            this.setValueFromMouse(mousePos.getX(), mousePos.getY());
            return true;
        }
        return false;
    }

    private void setValueFromMouse(double mouseX, double mouseY) {
        double x = (mouseX - (double)this.position.getX()) / (double)this.width;
        double y = (mouseY - (double)this.position.getY()) / (double)this.height;
        double newSaturation = Math.clamp(x, 0.0, 1.0);
        double newValue = Math.clamp(1.0 - y, 0.0, 1.0);
        this.applyValue((float)newSaturation, (float)newValue);
    }

    protected void applyValue(float newSaturation, float newValue) {
        if (!Mth.equal((float)this.saturation, (float)newSaturation) || !Mth.equal((float)this.value, (float)newValue)) {
            this.saturation = newSaturation;
            this.value = newValue;
            this.saturationAndValueSetter.accept(Float.valueOf(this.saturation), Float.valueOf(this.value));
        }
    }

    public void setHue(float hue) {
        this.hue = hue;
    }

    public void setValues(float saturation, float value) {
        this.saturation = saturation;
        this.value = value;
    }

    public void setPosition(Point position) {
        this.position = position;
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public Rect2i getBounds() {
        return new Rect2i(this.position.getX(), this.position.getY(), this.width, this.height);
    }
}

