/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.ae2addonlib.datagen;

import appeng.api.orientation.BlockOrientation;
import appeng.block.crafting.PatternProviderBlock;
import appeng.core.AppEng;
import appeng.core.definitions.BlockDefinition;
import appeng.core.definitions.ItemDefinition;
import appeng.datagen.providers.models.AE2BlockStateProvider;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.loaders.DynamicFluidContainerModelBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.pedroksl.ae2addonlib.AE2AddonLib;
import net.pedroksl.ae2addonlib.registry.helpers.FluidDefinition;

public abstract class AE2AddonModelProvider
extends AE2BlockStateProvider {
    public AE2AddonModelProvider(PackOutput packOutput, String modId, ExistingFileHelper exFileHelper) {
        super(packOutput, modId, exFileHelper);
    }

    protected void basicItem(ItemDefinition<?> item) {
        this.basicItem(item, null);
    }

    protected void basicItem(ItemDefinition<?> item, String texturePath) {
        if (texturePath == null) {
            this.itemModels().basicItem(item.asItem());
        } else {
            String namespace = item.id().getNamespace();
            String id = item.id().getPath();
            ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("item/" + texturePath + "/" + id));
            this.itemModels().singleTexture(id, this.mcLoc("item/generated"), "layer0", texture);
        }
    }

    protected void coloredItem(ItemDefinition<?> item) {
        String namespace = item.id().getNamespace();
        String id = item.id().getPath();
        ResourceLocation baseTexture = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("item/" + id + "_base"));
        ResourceLocation tintTexture = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("item/" + id + "_tint"));
        ((ItemModelBuilder)this.itemModels().singleTexture(id, this.mcLoc("item/generated"), "layer0", baseTexture)).texture("layer1", tintTexture);
    }

    protected void basicBlock(BlockDefinition<?> block) {
        this.simpleBlockAndItem(block);
    }

    protected void partItem(ItemDefinition<?> part) {
        this.partItem(part, false);
    }

    protected void partItem(ItemDefinition<?> part, boolean isBus) {
        String namespace = part.id().getNamespace();
        String id = part.id().getPath();
        String partName = id.substring(0, id.lastIndexOf(95));
        ResourceLocation front = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("part/" + partName));
        ResourceLocation back = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("part/" + partName + "_back"));
        ResourceLocation sides = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("part/" + partName + "_sides"));
        ResourceLocation base = isBus ? AppEng.makeId((String)"part/export_bus_base") : AppEng.makeId((String)"part/pattern_provider_base");
        ResourceLocation itemBase = isBus ? AppEng.makeId((String)"item/export_bus") : AppEng.makeId((String)"item/cable_pattern_provider");
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().singleTexture("part/" + id, base, "sidesStatus", AppEng.makeId((String)"part/monitor_sides_status"))).texture("sides", sides)).texture("front", front)).texture("back", back)).texture("particle", back);
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().singleTexture("item/" + id, itemBase, "sides", sides)).texture("front", front)).texture("back", back);
    }

    protected void patternProvider(BlockDefinition<?> block) {
        ModelFile patternProviderNormal = this.cubeAll(block.block());
        this.simpleBlockItem(block.block(), patternProviderNormal);
        String namespace = block.id().getNamespace();
        String blockName = block.id().getPath();
        BlockModelBuilder patternProviderOriented = (BlockModelBuilder)this.models().cubeBottomTop("block/" + blockName + "_oriented", ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/" + blockName + "_alt")), ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/" + blockName + "_back")), ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/" + blockName + "_front")));
        this.multiVariantGenerator(block, new Variant[]{Variant.variant()}).with(PropertyDispatch.property((Property)PatternProviderBlock.PUSH_DIRECTION).generate(dir -> {
            Direction forward = dir.getDirection();
            if (forward == null) {
                return Variant.variant().with(VariantProperties.MODEL, (Object)patternProviderNormal.getLocation());
            }
            BlockOrientation orientation = BlockOrientation.get((Direction)forward);
            return AE2AddonModelProvider.applyRotation((Variant)Variant.variant().with(VariantProperties.MODEL, (Object)patternProviderOriented.getLocation()), (int)(orientation.getAngleX() + 90), (int)orientation.getAngleY(), (int)0);
        }));
    }

    protected void stairsBlock(BlockDefinition<StairBlock> stairs, String bottomTexture, String sideTexture, String topTexture) {
        String namespace = stairs.id().getNamespace();
        String baseName = stairs.id().getPath();
        ResourceLocation side = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)sideTexture);
        ResourceLocation bottom = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)bottomTexture);
        ResourceLocation top = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)topTexture);
        ModelBuilder stairsModel = this.models().stairs(baseName, side, bottom, top);
        ModelBuilder stairsInner = this.models().stairsInner(baseName + "_inner", side, bottom, top);
        ModelBuilder stairsOuter = this.models().stairsOuter(baseName + "_outer", side, bottom, top);
        this.stairsBlock((StairBlock)stairs.block(), (ModelFile)stairsModel, (ModelFile)stairsInner, (ModelFile)stairsOuter);
        this.simpleBlockItem(stairs.block(), (ModelFile)stairsModel);
    }

    protected void slabBlock(BlockDefinition<SlabBlock> slab, BlockDefinition<?> base, String bottomTexture, String sideTexture, String topTexture) {
        String namespace = slab.id().getNamespace();
        ResourceLocation side = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)sideTexture);
        ResourceLocation bottom = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)bottomTexture);
        ResourceLocation top = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)topTexture);
        BlockModelBuilder bottomModel = (BlockModelBuilder)this.models().slab(slab.id().getPath(), side, bottom, top);
        this.simpleBlockItem(slab.block(), (ModelFile)bottomModel);
        this.slabBlock((SlabBlock)slab.block(), (ModelFile)bottomModel, (ModelFile)this.models().slabTop(slab.id().getPath() + "_top", side, bottom, top), (ModelFile)this.models().getExistingFile(base.id()));
    }

    protected void wall(BlockDefinition<WallBlock> block, String texture) {
        String namespace = block.id().getNamespace();
        ResourceLocation textureRL = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)texture);
        this.wallBlock((WallBlock)block.block(), textureRL);
        this.itemModels().wallInventory(block.id().getPath(), textureRL);
    }

    protected void waterBasedFluid(FluidDefinition<?, ?> fluid) {
        this.waterBasedFluidBlocks(fluid);
        this.bucket(fluid);
    }

    protected void waterBasedFluidBlocks(FluidDefinition<?, ?> fluid) {
        this.simpleBlock((Block)fluid.block(), (ModelFile)((BlockModelBuilder)this.models().getBuilder(fluid.blockHolder().getId().getPath())).texture("particle", AE2AddonLib.makeId("block/water_still")));
    }

    protected void bucket(FluidDefinition<?, ?> fluid) {
        ((DynamicFluidContainerModelBuilder)((ItemModelBuilder)this.itemModels().withExistingParent(fluid.bucketItemId().id().getPath(), ResourceLocation.fromNamespaceAndPath((String)"neoforge", (String)"item/bucket"))).customLoader(DynamicFluidContainerModelBuilder::begin)).fluid(fluid.bucketItem().content);
    }

    public String getName() {
        return "Block States / Models";
    }
}

