/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.ae2addonlib.network.serverPacket;

import appeng.api.features.HotkeyAction;
import appeng.core.AELog;
import appeng.core.localization.PlayerMessages;
import appeng.core.network.CustomAppEngPayload;
import appeng.core.network.ServerboundPacket;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.pedroksl.ae2addonlib.client.Hotkeys;
import net.pedroksl.ae2addonlib.registry.HotkeyRegistry;

public record AddonHotkeyPacket(String modId, String hotkey) implements ServerboundPacket
{
    public static final StreamCodec<RegistryFriendlyByteBuf, AddonHotkeyPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, AddonHotkeyPacket::modId, (StreamCodec)ByteBufCodecs.STRING_UTF8, AddonHotkeyPacket::hotkey, AddonHotkeyPacket::new);
    public static final CustomPacketPayload.Type<AddonHotkeyPacket> TYPE = CustomAppEngPayload.createType((String)"lib_hotkey");

    public AddonHotkeyPacket(Hotkeys.AddonHotkey hotkey) {
        this(hotkey.modId(), hotkey.name());
    }

    public CustomPacketPayload.Type<AddonHotkeyPacket> type() {
        return TYPE;
    }

    public void handleOnServer(ServerPlayer player) {
        List<HotkeyAction> actions = HotkeyRegistry.REGISTRY.get(this.modId).get(this.hotkey);
        if (actions == null) {
            player.sendSystemMessage((Component)PlayerMessages.UnknownHotkey.text().copy().append((Component)Component.translatable((String)("key.advanced_ae." + this.hotkey))));
            AELog.warn((String)"Player %s tried using unknown hotkey \"%s\"", (Object[])new Object[]{player, this.hotkey});
            return;
        }
        for (HotkeyAction action : actions) {
            if (action.run((Player)player)) break;
        }
    }
}

