/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.ae2addonlib.registry;

import appeng.block.AEBaseEntityBlock;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.core.definitions.BlockDefinition;
import appeng.core.definitions.DeferredBlockEntityType;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.slf4j.Logger;

public class BlockEntityRegistry {
    private static final Logger LOG = LogUtils.getLogger();
    private static final Map<String, DeferredRegister<BlockEntityType<?>>> DRMap = new HashMap();
    private static final Map<String, List<DeferredBlockEntityType<?>>> BLOCK_ENTITY_TYPES_MAP = new HashMap();
    private final String modId;

    public BlockEntityRegistry(String modId) {
        if (DRMap.containsKey(modId) && FMLEnvironment.dist.isClient()) {
            LOG.error("Tried to initialize AddonBlockEntities on Client Dist with mod id {}", (Object)modId);
            throw new IllegalStateException();
        }
        this.modId = modId;
        DRMap.put(modId, DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)modId));
        BLOCK_ENTITY_TYPES_MAP.put(modId, new ArrayList());
    }

    static DeferredRegister<BlockEntityType<?>> getDR(String modId) {
        DeferredRegister dr = DRMap.getOrDefault(modId, null);
        if (dr == null) {
            LOG.error("Tried to access uninitialized deferred register with mod id {}", (Object)modId);
            throw new IllegalStateException();
        }
        return dr;
    }

    public <T extends BlockEntity> List<BlockEntityType<? extends T>> getSubclassesOf(Class<T> baseClass) {
        return BlockEntityRegistry.getSubclassesOf(this.modId, baseClass);
    }

    public static <T extends BlockEntity> List<BlockEntityType<? extends T>> getSubclassesOf(String modId, Class<T> baseClass) {
        ArrayList<BlockEntityType<T>> result = new ArrayList<BlockEntityType<T>>();
        for (DeferredBlockEntityType type : (List)BLOCK_ENTITY_TYPES_MAP.getOrDefault(modId, new ArrayList())) {
            if (!baseClass.isAssignableFrom(type.getBlockEntityClass())) continue;
            result.add(type.get());
        }
        return result;
    }

    public List<BlockEntityType<?>> getImplementorsOf(Class<?> iface) {
        return BlockEntityRegistry.getImplementorsOf(this.modId, iface);
    }

    public static List<BlockEntityType<?>> getImplementorsOf(String modId, Class<?> iface) {
        ArrayList result = new ArrayList();
        for (DeferredBlockEntityType type : (List)BLOCK_ENTITY_TYPES_MAP.getOrDefault(modId, new ArrayList())) {
            if (!iface.isAssignableFrom(type.getBlockEntityClass())) continue;
            result.add(type.get());
        }
        return result;
    }

    @SafeVarargs
    protected static <T extends AEBaseBlockEntity> Supplier<BlockEntityType<T>> create(String modId, String id, Class<T> entityClass, BlockEntityFactory<T> factory, BlockDefinition<? extends AEBaseEntityBlock<?>> ... blockDefs) {
        if (blockDefs.length == 0) {
            throw new IllegalArgumentException();
        }
        DeferredHolder deferred = BlockEntityRegistry.getDR(modId).register(id, () -> {
            AEBaseEntityBlock[] blocks = (AEBaseEntityBlock[])Arrays.stream(blockDefs).map(BlockDefinition::block).toArray(AEBaseEntityBlock[]::new);
            AtomicReference<BlockEntityType> typeHolder = new AtomicReference<BlockEntityType>();
            BlockEntityType type = BlockEntityType.Builder.of((pos, state) -> factory.create((BlockEntityType)typeHolder.get(), pos, state), (Block[])blocks).build(null);
            typeHolder.setPlain(type);
            AEBaseBlockEntity.registerBlockEntityItem((BlockEntityType)type, (Item)blockDefs[0].asItem());
            for (AEBaseEntityBlock block : blocks) {
                block.setBlockEntity(entityClass, type, null, null);
            }
            return type;
        });
        DeferredBlockEntityType result = new DeferredBlockEntityType(entityClass, deferred);
        BLOCK_ENTITY_TYPES_MAP.get(modId).add(result);
        return result;
    }

    public void register(IEventBus eventBus) {
        BlockEntityRegistry.getDR(this.modId).register(eventBus);
    }

    protected static interface BlockEntityFactory<T extends AEBaseBlockEntity> {
        public T create(BlockEntityType<T> var1, BlockPos var2, BlockState var3);
    }
}

